/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.export;

import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.RepositoryInfo;
import fedora.utilities.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class AutoExporter
implements Constants {
    private final FedoraAPIM m_apim;
    private final FedoraAPIA m_apia;
    private static HashMap<FedoraAPIA, RepositoryInfo> s_repoInfo = new HashMap();

    public AutoExporter(FedoraAPIA apia, FedoraAPIM apim) throws MalformedURLException, ServiceException {
        this.m_apia = apia;
        this.m_apim = apim;
    }

    public void export(String pid, String format, String exportContext, OutputStream outStream) throws RemoteException, IOException {
        AutoExporter.export(this.m_apia, this.m_apim, pid, format, exportContext, outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void export(FedoraAPIA apia, FedoraAPIM apim, String pid, String format, String exportContext, OutputStream outStream) throws RemoteException, IOException {
        byte[] bytes;
        block19: {
            block17: {
                block20: {
                    block21: {
                        int majorVersion;
                        block18: {
                            StringTokenizer stoken;
                            RepositoryInfo repoinfo = s_repoInfo.get(apia);
                            if (repoinfo == null) {
                                repoinfo = apia.describeRepository();
                                s_repoInfo.put(apia, repoinfo);
                            }
                            if ((majorVersion = new Integer((stoken = new StringTokenizer(repoinfo.getRepositoryVersion(), ".")).nextToken()).intValue()) >= 2) break block18;
                            if (!(format == null || format.equals(AutoExporter.METS_EXT1_1.uri) || format.equals(AutoExporter.METS_EXT1_0.uri) || format.equals("METS_EXT1_0_LEGACY"))) {
                                if (!format.equals("default")) throw new IOException("You are connected to a pre-2.0 Fedora repository which will only export the XML format \"metslikefedora1\".");
                            }
                            if (format.equals(AutoExporter.METS_EXT1_1.uri)) {
                                System.out.println("WARNING: Repository does not support METS Fedora Extension 1.1; exporting older format (v1.0) instead");
                            }
                            bytes = apim.export(pid, "metslikefedora1", exportContext);
                            break block19;
                        }
                        if (majorVersion >= 3) break block20;
                        if (format == null) break block17;
                        if (!format.equals(AutoExporter.FOXML1_1.uri)) break block21;
                        System.out.println("WARNING: Repository does not support FOXML 1.1; exporting older format (v1.0) instead");
                        format = "foxml1.0";
                        break block17;
                    }
                    if (format.equals(AutoExporter.FOXML1_0.uri)) {
                        format = "foxml1.0";
                        break block17;
                    } else if (format.equals(AutoExporter.METS_EXT1_1.uri)) {
                        System.out.println("WARNING: Repository does not support METS Fedora Extension 1.1; exporting older format (v1.0) instead");
                        format = "metslikefedora1";
                        break block17;
                    } else {
                        if (!format.equals(AutoExporter.METS_EXT1_0.uri)) throw new IOException("You are connected to a 2.x Fedora repository which will only export FOXML and METS XML formats.");
                        format = "metslikefedora1";
                    }
                    break block17;
                }
                if (format != null) {
                    if (format.equals("foxml1.0")) {
                        format = AutoExporter.FOXML1_0.uri;
                    } else if (format.equals("metslikefedora1")) {
                        format = AutoExporter.METS_EXT1_0.uri;
                    }
                }
                AutoExporter.validateFormat(format);
            }
            bytes = apim.export(pid, format, exportContext);
        }
        try {
            try {
                if (format.equals(AutoExporter.ATOM_ZIP1_1.uri)) {
                    FileUtils.copy(new ByteArrayInputStream(bytes), outStream);
                }
                OutputFormat fmt = new OutputFormat("XML", "UTF-8", true);
                fmt.setIndent(2);
                fmt.setLineWidth(120);
                fmt.setPreserveSpace(false);
                XMLSerializer ser = new XMLSerializer(outStream, fmt);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(bytes));
                ser.serialize(doc);
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e.getClass().getName() + " : " + e.getMessage());
                Object var16_17 = null;
                outStream.close();
                return;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            outStream.close();
            throw throwable;
        }
        outStream.close();
    }

    public void getObjectXML(String pid, OutputStream outStream) throws RemoteException, IOException {
        AutoExporter.getObjectXML(this.m_apia, this.m_apim, pid, outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void getObjectXML(FedoraAPIA apia, FedoraAPIM apim, String pid, OutputStream outStream) throws RemoteException, IOException {
        RepositoryInfo repoinfo = s_repoInfo.get(apia);
        if (repoinfo == null) {
            repoinfo = apia.describeRepository();
            s_repoInfo.put(apia, repoinfo);
        }
        byte[] bytes = apim.getObjectXML(pid);
        try {
            try {
                OutputFormat fmt = new OutputFormat("XML", "UTF-8", true);
                fmt.setIndent(2);
                fmt.setLineWidth(120);
                fmt.setPreserveSpace(false);
                XMLSerializer ser = new XMLSerializer(outStream, fmt);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(bytes));
                ser.serialize(doc);
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e.getClass().getName() + " : " + e.getMessage());
                Object var12_13 = null;
                outStream.close();
                return;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            outStream.close();
            throw throwable;
        }
        outStream.close();
    }

    public static void validateFormat(String format) throws IOException {
        if (format == null) {
            return;
        }
        if (!(format.equals(AutoExporter.FOXML1_1.uri) || format.equals(AutoExporter.FOXML1_0.uri) || format.equals(AutoExporter.METS_EXT1_1.uri) || format.equals(AutoExporter.METS_EXT1_0.uri) || format.equals(AutoExporter.ATOM1_1.uri) || format.equals(AutoExporter.ATOM_ZIP1_1.uri) || format.equals("default"))) {
            throw new IOException("Invalid export format. Valid FORMAT values are: '" + AutoExporter.FOXML1_1.uri + "' '" + AutoExporter.FOXML1_0.uri + "' '" + AutoExporter.METS_EXT1_1.uri + "' '" + AutoExporter.METS_EXT1_0.uri + "' '" + AutoExporter.ATOM1_1.uri + "' '" + AutoExporter.ATOM_ZIP1_1.uri + "' and 'default'");
        }
    }
}

