/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.export;

import fedora.client.FedoraClient;
import fedora.client.utility.AutoFinder;
import fedora.client.utility.export.AutoExporter;
import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.FieldSearchQuery;
import fedora.server.types.gen.FieldSearchResult;
import fedora.server.types.gen.ObjectFields;
import fedora.server.types.gen.RepositoryInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.util.StringTokenizer;

public class Export
implements Constants {
    public static String getDuration(long millis) {
        long tsec = millis / 1000L;
        long h = tsec / 60L / 60L;
        long m = (tsec - h * 60L * 60L) / 60L;
        long s = tsec - h * 60L * 60L - m * 60L;
        StringBuffer out = new StringBuffer();
        if (h > 0L) {
            out.append(h + " hour");
            if (h > 1L) {
                out.append('s');
            }
        }
        if (m > 0L) {
            if (h > 0L) {
                out.append(", ");
            }
            out.append(m + " minute");
            if (m > 1L) {
                out.append('s');
            }
        }
        if (s > 0L || h == 0L && m == 0L) {
            if (h > 0L || m > 0L) {
                out.append(", ");
            }
            out.append(s + " second");
            if (s != 1L) {
                out.append('s');
            }
        }
        return out.toString();
    }

    public static void one(FedoraAPIA apia, FedoraAPIM apim, String pid, String format, String exportContext, File dir) throws Exception {
        String suffix = format.equals(Export.ATOM_ZIP1_1.uri) ? ".zip" : ".xml";
        String fName = pid.replaceAll(":", "_") + suffix;
        File file = new File(dir, fName);
        System.out.println("Exporting " + pid + " to " + file.getPath());
        AutoExporter.export(apia, apim, pid, format, exportContext, new FileOutputStream(file));
    }

    public static int multi(FedoraAPIA apia, FedoraAPIM apim, String format, String exportContext, File dir) throws Exception {
        int count = 0;
        FieldSearchQuery query = new FieldSearchQuery();
        query.setTerms(null);
        String[] resultFields = new String[]{"pid"};
        FieldSearchResult result = AutoFinder.findObjects(apia, resultFields, 100, query);
        while (result != null) {
            ObjectFields[] ofs;
            for (ObjectFields element : ofs = result.getResultList()) {
                String pid = element.getPid();
                Export.one(apia, apim, pid, format, exportContext, dir);
                ++count;
            }
            String token = null;
            try {
                token = result.getListSession().getToken();
            }
            catch (Throwable th) {
                // empty catch block
            }
            if (token != null) {
                result = AutoFinder.resumeFindObjects(apia, token);
                continue;
            }
            result = null;
        }
        return count;
    }

    public static void badArgs(String msg) {
        System.err.println("Command: fedora-export");
        System.err.println();
        System.err.println("Summary: Exports one or more objects from a Fedora repository.");
        System.err.println();
        System.err.println("Syntax:");
        System.err.println("  fedora-export HST:PRT USR PSS PID|FTYPS FORMAT ECONTEXT PATH PROTOCOL");
        System.err.println();
        System.err.println("Where:");
        System.err.println("  HST    is the repository hostname.");
        System.err.println("  PRT    is the repository port number.");
        System.err.println("  USR    is the id of the repository user.");
        System.err.println("  PSS    is the password of repository user.");
        System.err.println("  PID    is the id of the object to export from the source repository.");
        System.err.println("  FORMAT is the XML format to export ");
        System.err.println("         ('" + Export.FOXML1_1.uri + "',");
        System.err.println("          '" + Export.FOXML1_0.uri + "',");
        System.err.println("          '" + Export.METS_EXT1_1.uri + "',");
        System.err.println("          '" + Export.METS_EXT1_0.uri + "',");
        System.err.println("          '" + Export.ATOM1_1.uri + "',");
        System.err.println("          '" + Export.ATOM_ZIP1_1.uri + "',");
        System.err.println("          or 'default')");
        System.err.println("  ECONTEXT is the export context (which indicates what use case");
        System.err.println("         the output should be prepared for.");
        System.err.println("         ('public', 'migrate', 'archive' or 'default')");
        System.err.println("  PATH   is the directory to export the object.");
        System.err.println("  PROTOCOL is the how to connect to repository, either http or https.");
        System.err.println();
        System.err.println("Examples:");
        System.err.println("fedora-export myrepo.com:8443 user pw demo:1 " + Export.FOXML1_1.uri + " migrate . https");
        System.err.println();
        System.err.println("  Exports demo:1 for migration in FOXML format ");
        System.err.println("  using the secure https protocol (SSL).");
        System.err.println("  (from myrepo.com:80 to the current directory).");
        System.err.println();
        System.err.println("fedora-export myrepo.com:80 user pw DMO default default /tmp/fedoradump http");
        System.err.println();
        System.err.println("  Exports all objects in the default export format and context ");
        System.err.println("  (from myrepo.com:80 to directory /tmp/fedoradump).");
        System.err.println();
        System.err.println("ERROR  : " + msg);
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            RepositoryInfo repoinfo;
            StringTokenizer stoken;
            int majorVersion;
            String protocol;
            String[] hp;
            if (args.length != 8) {
                Export.badArgs("Wrong number of arguments.");
            }
            if ((hp = args[0].split(":")).length != 2) {
                Export.badArgs("First arg must be of the form 'host:portnum'");
            }
            if (!(protocol = args[7]).equals("http") && !protocol.equals("https")) {
                Export.badArgs("PROTOCOL arg must be 'http' or 'https'");
            }
            String baseURL = protocol + "://" + hp[0] + ":" + Integer.parseInt(hp[1]) + "/fedora";
            FedoraClient fc = new FedoraClient(baseURL, args[1], args[2]);
            FedoraAPIA sourceRepoAPIA = fc.getAPIA();
            FedoraAPIM sourceRepoAPIM = fc.getAPIM();
            String exportFormat = args[4];
            String exportContext = args[5];
            if (!(exportFormat.equals(Export.FOXML1_1.uri) || exportFormat.equals(Export.FOXML1_0.uri) || exportFormat.equals(Export.METS_EXT1_1.uri) || exportFormat.equals(Export.METS_EXT1_0.uri) || exportFormat.equals(Export.ATOM1_1.uri) || exportFormat.equals(Export.ATOM_ZIP1_1.uri) || exportFormat.equals("default"))) {
                Export.badArgs(exportFormat + " is not a valid export format.");
            }
            if (!(exportContext.equals("public") || exportContext.equals("migrate") || exportContext.equals("archive") || exportContext.equals("default"))) {
                Export.badArgs("ECONTEXT arg must be 'public', 'migrate', 'archive', or 'default'");
            }
            if ((majorVersion = new Integer((stoken = new StringTokenizer((repoinfo = sourceRepoAPIA.describeRepository()).getRepositoryVersion(), ".")).nextToken()).intValue()) < 2 && !exportFormat.equals(Export.METS_EXT1_0.uri) && !exportFormat.equals("default")) {
                Export.badArgs("FORMAT arg must be '" + Export.METS_EXT1_0.uri + "' or 'default' for pre-2.0 repository.");
            }
            if (exportFormat.equals("default")) {
                exportFormat = null;
            }
            if (exportContext.equals("default")) {
                exportContext = null;
            }
            if (args[3].indexOf(":") == -1) {
                int count = Export.multi(sourceRepoAPIA, sourceRepoAPIM, exportFormat, exportContext, new File(args[6]));
                System.out.print("Exported " + count + " objects.");
            } else {
                Export.one(sourceRepoAPIA, sourceRepoAPIM, args[3], exportFormat, exportContext, new File(args[6]));
                System.out.println("Exported " + args[3]);
            }
        }
        catch (Exception e) {
            System.err.print("Error  : ");
            if (e.getMessage() == null) {
                e.printStackTrace();
            }
            System.err.print(e.getMessage());
        }
    }
}

