/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate;

import fedora.client.utility.validate.InvalidContentModelException;
import fedora.client.utility.validate.ObjectSource;
import fedora.client.utility.validate.ObjectSourceException;
import fedora.client.utility.validate.ValidationResult;
import fedora.client.utility.validate.ValidationResultNotation;
import fedora.client.utility.validate.types.BasicObjectInfo;
import fedora.client.utility.validate.types.ContentModelInfo;
import fedora.client.utility.validate.types.DatastreamInfo;
import fedora.client.utility.validate.types.ObjectInfo;
import fedora.client.utility.validate.types.RelationshipInfo;
import fedora.common.Constants;
import java.util.Collection;

public class ObjectValidator {
    private final ObjectSource objectSource;

    public ObjectValidator(ObjectSource objectSource) {
        if (objectSource == null) {
            throw new NullPointerException("objectSource may not be null.");
        }
        this.objectSource = objectSource;
    }

    public ValidationResult validate(String pid) {
        if (pid == null) {
            throw new NullPointerException("pid may not be null.");
        }
        ObjectInfo object = null;
        try {
            object = this.objectSource.getValidationObject(pid);
        }
        catch (ObjectSourceException e) {
            // empty catch block
        }
        if (object == null) {
            ValidationResult result = new ValidationResult(new BasicObjectInfo(pid));
            result.addNote(ValidationResultNotation.objectNotFound(pid));
            return result;
        }
        return this.validate(object);
    }

    public ValidationResult validate(ObjectInfo object) {
        if (object == null) {
            throw new NullPointerException("object may not be null.");
        }
        ValidationResult result = new ValidationResult(object);
        if (!object.hasRelation(Constants.MODEL.HAS_MODEL.uri)) {
            result.addNote(ValidationResultNotation.noContentModel());
            return result;
        }
        for (RelationshipInfo relation : object.getRelations(Constants.MODEL.HAS_MODEL.uri)) {
            this.validateAgainstContentModel(result, relation, object);
        }
        return result;
    }

    private void validateAgainstContentModel(ValidationResult result, RelationshipInfo relation, ObjectInfo object) {
        String contentModelPid = relation.getObjectPid();
        if (contentModelPid == null) {
            result.addNote(ValidationResultNotation.unrecognizedContentModelUri(relation.getObject()));
            return;
        }
        try {
            ContentModelInfo contentModel = this.objectSource.getContentModelInfo(contentModelPid);
            if (contentModel == null) {
                result.addNote(ValidationResultNotation.contentModelNotFound(contentModelPid));
            } else {
                for (ContentModelInfo.DsTypeModel typeModel : contentModel.getTypeModels()) {
                    this.confirmMatchForDsTypeModel(result, typeModel, contentModelPid, object);
                }
            }
        }
        catch (ObjectSourceException e) {
            result.addNote(ValidationResultNotation.errorFetchingContentModel(contentModelPid, e));
            return;
        }
        catch (InvalidContentModelException e) {
            result.addNote(ValidationResultNotation.contentModelNotValid(e));
        }
    }

    private void confirmMatchForDsTypeModel(ValidationResult result, ContentModelInfo.DsTypeModel typeModel, String contentModelPid, ObjectInfo object) {
        String id = typeModel.getId();
        DatastreamInfo dsInfo = object.getDatastreamInfo(id);
        if (dsInfo == null) {
            result.addNote(ValidationResultNotation.noMatchingDatastreamId(contentModelPid, id));
            return;
        }
        Collection<ContentModelInfo.Form> forms = typeModel.getForms();
        if (forms.isEmpty()) {
            return;
        }
        for (ContentModelInfo.Form form : forms) {
            if (!this.meetsConstraint(dsInfo.getMimeType(), form.getMimeType()) || !this.meetsConstraint(dsInfo.getFormatUri(), form.getFormatUri())) continue;
            return;
        }
        result.addNote(ValidationResultNotation.datastreamDoesNotMatchForms(contentModelPid, id));
    }

    private boolean meetsConstraint(String value, String constraint) {
        return constraint == null || constraint.equals(value);
    }
}

