/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate;

import fedora.client.utility.validate.ValidationResultNotation;
import fedora.client.utility.validate.types.ObjectInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResult {
    private final ObjectInfo object;
    private final List<ValidationResultNotation> notes = new ArrayList<ValidationResultNotation>();

    public ValidationResult(ObjectInfo object) {
        if (object == null) {
            throw new IllegalArgumentException("object may not be null.");
        }
        this.object = object;
    }

    public void addNote(ValidationResultNotation note) {
        this.notes.add(note);
    }

    public ObjectInfo getObject() {
        return this.object;
    }

    public Collection<ValidationResultNotation> getNotes() {
        return new ArrayList<ValidationResultNotation>(this.notes);
    }

    public Level getSeverityLevel() {
        Level severity = Level.INFO;
        for (ValidationResultNotation note : this.notes) {
            Level noteLevel = note.getLevel();
            if (noteLevel.compareTo(severity) <= 0) continue;
            severity = noteLevel;
        }
        return severity;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ValidationResult that = (ValidationResult)obj;
        return this.object.equals(that.object) && ((Object)this.notes).equals(that.notes);
    }

    public int hashCode() {
        return this.object.hashCode() ^ ((Object)this.notes).hashCode();
    }

    public String toString() {
        return "pid='" + this.object.getPid() + "', " + " Notes=" + this.notes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

