/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate;

import fedora.client.utility.validate.InvalidContentModelException;
import fedora.client.utility.validate.ObjectSourceException;
import fedora.client.utility.validate.ValidationResult;

public class ValidationResultNotation {
    private final ValidationResult.Level level;
    private final String category;
    private final String message;

    public static ValidationResultNotation objectNotFound(String pid) {
        return new ValidationResultNotation(ValidationResult.Level.ERROR, "ObjectNotFound", "Object not found for pid '" + pid + "'");
    }

    public static ValidationResultNotation noContentModel() {
        return new ValidationResultNotation(ValidationResult.Level.INFO, "NoContentModel", "No content model.");
    }

    public static ValidationResultNotation unrecognizedContentModelUri(String uri) {
        return new ValidationResultNotation(ValidationResult.Level.INFO, "UnrecognizedContentModelUri", "Content model URI is not recognized as an object PID: '" + uri + "'");
    }

    public static ValidationResultNotation contentModelNotFound(String pid) {
        return new ValidationResultNotation(ValidationResult.Level.INFO, "ContentModelNotFound", "Content model was not found, PID='" + pid + "'");
    }

    public static ValidationResultNotation errorFetchingContentModel(String pid, ObjectSourceException e) {
        return new ValidationResultNotation(ValidationResult.Level.ERROR, "ErrorFetchingContentModel", "Attempt to fetch Content model '" + pid + "' produced this error '" + e + "'");
    }

    public static ValidationResultNotation contentModelNotValid(InvalidContentModelException e) {
        return new ValidationResultNotation(ValidationResult.Level.ERROR, "ContentModelNotValid", "Attempt to build Content Model '" + e.getContentModelPid() + "' produced this error '" + e + "'");
    }

    public static ValidationResultNotation noMatchingDatastreamId(String contentModelPid, String dsId) {
        return new ValidationResultNotation(ValidationResult.Level.ERROR, "NoMatchingDatastreamId", "Object has no datastream '" + dsId + "', required by content model '" + contentModelPid + "'");
    }

    public static ValidationResultNotation datastreamDoesNotMatchForms(String contentModelPid, String dsId) {
        return new ValidationResultNotation(ValidationResult.Level.ERROR, "DatastreamDoesNotMatchForms", "Datastream '" + dsId + "' doesn't match any form " + "in the corresponding type " + "model of content model '" + contentModelPid + "'.");
    }

    private ValidationResultNotation(ValidationResult.Level level, String category, String message) {
        if (level == null) {
            throw new IllegalArgumentException("level may not be null.");
        }
        this.level = level;
        this.message = message == null ? "" : message;
        this.category = category == null ? "" : category;
    }

    public ValidationResult.Level getLevel() {
        return this.level;
    }

    public String getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ValidationResultNotation that = (ValidationResultNotation)obj;
        return this.equivalent((Object)this.level, (Object)that.level) && this.equivalent(this.category, that.category) && this.equivalent(this.message, that.message);
    }

    private boolean equivalent(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public int hashCode() {
        return this.hashIt((Object)this.level) ^ this.hashIt(this.category) ^ this.hashIt(this.message);
    }

    private int hashIt(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public String toString() {
        return (Object)((Object)this.level) + " [" + this.category + "] " + this.message;
    }
}

