/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.process;

import fedora.client.utility.validate.ValidationResult;
import fedora.client.utility.validate.ValidationResultNotation;
import fedora.client.utility.validate.ValidationResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class Log4jValidationResults
implements ValidationResults {
    public static final String LOGGING_CATEGORY_PREFIX = "Validator";
    private static final Properties DEFAULT_CONFIG_PROPERTIES = Log4jValidationResults.initDefaultProperties();
    private int numberOfErrors;
    private int numberOfFilteredErrors;
    private int numberOfWarnings;
    private int numberOfFilteredWarnings;
    private int numberOfValidObjects;
    private int numberOfInvalidObjects;
    private int numberOfIndeterminateObjects;

    private static Properties initDefaultProperties() {
        Properties props = new Properties();
        props.put("log4j.appender.STDOUT", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.STDOUT.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.STDOUT.layout.ConversionPattern", "%d{yyyy-MM-dd' 'HH:mm:ss.SSS} %p [%c] %m%n");
        props.put("log4j.rootLogger", "INFO, STDOUT");
        props.put("log4j.appender.VALIDATOR", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.VALIDATOR.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.VALIDATOR.layout.ConversionPattern", "%p [%c] %m%n");
        props.put("log4j.logger.Validator=INFO", "INFO, VALIDATOR");
        props.put("log4j.additivity.Validator", "false");
        return props;
    }

    public Log4jValidationResults(Properties configProperties) {
        LogManager.resetConfiguration();
        if (configProperties == null || configProperties.isEmpty()) {
            PropertyConfigurator.configure((Properties)DEFAULT_CONFIG_PROPERTIES);
        } else {
            PropertyConfigurator.configure((Properties)configProperties);
        }
    }

    public void record(ValidationResult rawResult) {
        this.getBaseLogger().debug((Object)rawResult.toString());
        Log4jValidationResult result = new Log4jValidationResult(rawResult);
        this.incrementTallys(result);
        for (Log4jNote note : result.getNotes()) {
            note.log();
        }
    }

    public void closeResults() {
        Logger logger = this.getBaseLogger();
        logger.info((Object)("Validated " + this.numberOfObjects() + " objects: " + this.numberOfValidObjects + " valid, " + this.numberOfInvalidObjects + " invalid, " + this.numberOfIndeterminateObjects + " indeterminate."));
        if (this.numberOfErrors == this.numberOfFilteredErrors && this.numberOfWarnings == this.numberOfFilteredWarnings) {
            logger.info((Object)(this.numberOfErrors + " errors, " + this.numberOfWarnings + " warnings."));
        } else {
            logger.info((Object)(this.numberOfFilteredErrors + " filtered errors (" + this.numberOfErrors + " unfiltered), " + this.numberOfFilteredWarnings + " filtered warnings (" + this.numberOfWarnings + " unfiltered)"));
        }
    }

    private int numberOfObjects() {
        return this.numberOfValidObjects + this.numberOfIndeterminateObjects + this.numberOfInvalidObjects;
    }

    private void incrementTallys(Log4jValidationResult result) {
        switch (result.getSeverityLevel()) {
            case ERROR: {
                ++this.numberOfInvalidObjects;
                break;
            }
            case WARN: {
                ++this.numberOfIndeterminateObjects;
                break;
            }
            default: {
                ++this.numberOfValidObjects;
            }
        }
        for (Log4jNote note : result.getNotes()) {
            switch (note.getLevel()) {
                case ERROR: {
                    ++this.numberOfErrors;
                    break;
                }
                case WARN: {
                    ++this.numberOfWarnings;
                    break;
                }
            }
            if (!note.isLoggable()) continue;
            switch (note.getLevel()) {
                case ERROR: {
                    ++this.numberOfFilteredErrors;
                    break;
                }
                case WARN: {
                    ++this.numberOfFilteredWarnings;
                    break;
                }
            }
        }
    }

    private Logger getBaseLogger() {
        return Logger.getLogger((String)LOGGING_CATEGORY_PREFIX);
    }

    private static class Log4jNote {
        private final ValidationResult.Level level;
        private final Level loggingLevel;
        private final Logger logger;
        private final boolean loggable;
        private final String message;

        public Log4jNote(ValidationResultNotation rawNote, String objectPid) {
            this.level = rawNote.getLevel();
            this.loggingLevel = Level.toLevel((String)rawNote.getLevel().toString());
            String category = "Validator." + rawNote.getCategory();
            this.logger = Logger.getLogger((String)category);
            this.loggable = this.loggingLevel.isGreaterOrEqual((Priority)this.logger.getEffectiveLevel());
            this.message = "pid='" + objectPid + "'  " + rawNote.getMessage();
        }

        public ValidationResult.Level getLevel() {
            return this.level;
        }

        public boolean isLoggable() {
            return this.loggable;
        }

        public void log() {
            if (this.loggable) {
                this.logger.log((Priority)this.loggingLevel, (Object)this.message);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Log4jValidationResult {
        private final String pid;
        private final ValidationResult.Level severityLevel;
        private final List<Log4jNote> notes;

        public Log4jValidationResult(ValidationResult rawResult) {
            this.pid = rawResult.getObject().getPid();
            this.severityLevel = rawResult.getSeverityLevel();
            ArrayList<Log4jNote> notes = new ArrayList<Log4jNote>();
            for (ValidationResultNotation rawNote : rawResult.getNotes()) {
                notes.add(new Log4jNote(rawNote, this.pid));
            }
            this.notes = Collections.unmodifiableList(notes);
        }

        public String getPid() {
            return this.pid;
        }

        public ValidationResult.Level getSeverityLevel() {
            return this.severityLevel;
        }

        public List<Log4jNote> getNotes() {
            return this.notes;
        }
    }
}

