/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PidfileIterator
implements Iterator<String> {
    private final BufferedReader reader;
    private boolean eof;
    private String nextLine;

    public PidfileIterator(File pidfile) {
        if (pidfile == null) {
            throw new NullPointerException("pidfile may not be null.");
        }
        try {
            this.reader = new BufferedReader(new FileReader(pidfile));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.fillNextLine();
    }

    private void fillNextLine() {
        try {
            while (this.nextLine == null && !this.eof) {
                String line = this.reader.readLine();
                if (line == null) {
                    this.eof = true;
                    this.reader.close();
                    continue;
                }
                if (this.isBlank(line) || this.isComment(line)) continue;
                this.nextLine = line;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isComment(String line) {
        String trimmed = line.trim();
        if (trimmed.length() == 0) {
            return false;
        }
        return trimmed.charAt(0) == '#';
    }

    private boolean isBlank(String line) {
        return line.trim().length() == 0;
    }

    @Override
    public boolean hasNext() {
        this.fillNextLine();
        return !this.eof;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String result = this.nextLine;
        this.nextLine = null;
        this.fillNextLine();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

