/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.process;

import fedora.client.utility.validate.ObjectSourceException;
import fedora.client.utility.validate.ObjectValidator;
import fedora.client.utility.validate.process.Log4jValidationResults;
import fedora.client.utility.validate.process.PidfileIterator;
import fedora.client.utility.validate.process.ValidatorProcessParameters;
import fedora.client.utility.validate.process.ValidatorProcessUsageException;
import fedora.client.utility.validate.remote.RemoteObjectSource;
import fedora.client.utility.validate.remote.ServiceInfo;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.rpc.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorProcess {
    private static RemoteObjectSource openObjectSource(ServiceInfo serviceInfo) {
        try {
            return new RemoteObjectSource(serviceInfo);
        }
        catch (ServiceException e) {
            throw new IllegalStateException("Failed to initialize the ValidatorProcess: ", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize the ValidatorProcess: ", e);
        }
    }

    private static Iterator<String> getPidIterator(ValidatorProcessParameters parms, RemoteObjectSource objectSource) throws ObjectSourceException {
        if (parms.getIteratorType() == ValidatorProcessParameters.IteratorType.FS_QUERY) {
            return objectSource.findObjectPids(parms.getQuery());
        }
        return new PidfileIterator(parms.getPidfile());
    }

    public static void main(String[] args) throws ObjectSourceException {
        try {
            ValidatorProcessParameters parms = new ValidatorProcessParameters(args);
            RemoteObjectSource objectSource = ValidatorProcess.openObjectSource(parms.getServiceInfo());
            Log4jValidationResults results = new Log4jValidationResults(parms.getLogConfigProperties());
            Iterator<String> pids = ValidatorProcess.getPidIterator(parms, objectSource);
            ObjectValidator validator = new ObjectValidator(objectSource);
            while (pids.hasNext()) {
                results.record(validator.validate(pids.next()));
            }
            results.closeResults();
        }
        catch (ValidatorProcessUsageException e) {
            System.err.println(e.getMessage());
        }
    }
}

