/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.process;

import fedora.client.utility.validate.process.ValidatorProcessUsageException;
import fedora.client.utility.validate.remote.ServiceInfo;
import fedora.server.errors.QueryParseException;
import fedora.server.search.Condition;
import fedora.server.search.FieldSearchQuery;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorProcessParameters {
    public static final String USAGE = "usage: ValidatorProcess -serverurl <url> -username <username> -password <password> {-terms <terms> | -query <query> | -pidfile <path>} [-logConfig <filename>]";
    public static final String PARAMETER_SERVER_URL = "-serverurl";
    public static final String PARAMETER_USERNAME = "-username";
    public static final String PARAMETER_PASSWORD = "-password";
    public static final String PARAMETER_TERMS = "-terms";
    public static final String PARAMETER_QUERY = "-query";
    public static final String PARAMETER_PIDFILE = "-pidfile";
    public static final String PARAMETER_LOG_CONFIG = "-logConfig";
    private static final Set<String> ALL_PARAMETERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("-serverurl", "-username", "-password", "-terms", "-query", "-pidfile", "-logConfig")));
    private final ServiceInfo serviceInfo;
    private final Properties logConfigProperties;
    private final IteratorType iteratorType;
    private final FieldSearchQuery fieldSearchQuery;
    private final File pidfile;

    public ValidatorProcessParameters(String[] args) {
        Map<String, String> parms = this.parseArgsIntoMap(args);
        String username = this.getRequiredParameter(PARAMETER_USERNAME, parms);
        String password = this.getRequiredParameter(PARAMETER_PASSWORD, parms);
        URL serverUrl = this.getRequiredUrlParameter(PARAMETER_SERVER_URL, parms);
        this.serviceInfo = new ServiceInfo(serverUrl, username, password);
        String query = this.getOptionalParameter(PARAMETER_QUERY, parms);
        String terms = this.getOptionalParameter(PARAMETER_TERMS, parms);
        String pidfileParm = this.getOptionalParameter(PARAMETER_PIDFILE, parms);
        this.iteratorType = this.figureOutIteratorType(query, terms, pidfileParm);
        if (this.iteratorType == IteratorType.FS_QUERY) {
            this.fieldSearchQuery = this.assembleFieldSearchQuery(query, terms);
            this.pidfile = null;
        } else {
            this.fieldSearchQuery = null;
            this.pidfile = this.assemblePidfile(pidfileParm);
        }
        String logConfigFile = this.getOptionalParameter(PARAMETER_LOG_CONFIG, parms);
        this.logConfigProperties = this.readLogConfigFile(logConfigFile);
    }

    private Map<String, String> parseArgsIntoMap(String[] args) {
        HashMap<String, String> parms = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (!this.isKeyword(key)) {
                throw new ValidatorProcessUsageException("'" + key + "' is not a keyword.");
            }
            if (!ALL_PARAMETERS.contains(key)) {
                throw new ValidatorProcessUsageException("'" + key + "' is not a recognized keyword.");
            }
            if (i >= args.length - 1) {
                parms.put(key, null);
                continue;
            }
            String value = args[i + 1];
            if (this.isKeyword(value)) {
                parms.put(key, null);
                continue;
            }
            parms.put(key, value);
            ++i;
        }
        return parms;
    }

    private boolean isKeyword(String arg) {
        return arg.startsWith("-");
    }

    private String getRequiredParameter(String keyword, Map<String, String> parms) {
        if (!parms.containsKey(keyword)) {
            throw new ValidatorProcessUsageException("Parameter '" + keyword + "' is required.");
        }
        String value = parms.get(keyword);
        if (value == null) {
            throw new ValidatorProcessUsageException("Parameter '" + keyword + "' requires a value.");
        }
        return value;
    }

    private URL getRequiredUrlParameter(String keyword, Map<String, String> parms) {
        String urlString = this.getRequiredParameter(keyword, parms);
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new ValidatorProcessUsageException("Value '" + urlString + "' for parameter '" + keyword + "' is not a valid URL: " + e.getMessage());
        }
    }

    private String getOptionalParameter(String keyword, Map<String, String> parms) {
        if (!parms.containsKey(keyword)) {
            return null;
        }
        String value = parms.get(keyword);
        if (value == null) {
            throw new ValidatorProcessUsageException("If parameter '" + keyword + "' is provided, it must have a value.");
        }
        return value;
    }

    private IteratorType figureOutIteratorType(String query, String terms, String pidfileParm) {
        int howMany = (query == null ? 0 : 1) + (terms == null ? 0 : 1) + (pidfileParm == null ? 0 : 1);
        if (howMany == 0) {
            throw new ValidatorProcessUsageException("You must provide either '-query', '-terms' or '-pidfile'.");
        }
        if (howMany > 1) {
            throw new ValidatorProcessUsageException("You must provide only one of these parameters: '-query', '-terms' or '-pidfile'.");
        }
        return pidfileParm == null ? IteratorType.FS_QUERY : IteratorType.PIDFILE;
    }

    private FieldSearchQuery assembleFieldSearchQuery(String query, String terms) {
        if (terms != null) {
            return new FieldSearchQuery(terms);
        }
        try {
            return new FieldSearchQuery(Condition.getConditions(query));
        }
        catch (QueryParseException e) {
            throw new ValidatorProcessUsageException("Value '" + query + "' of parameter '" + PARAMETER_QUERY + "' is not a valid query string.");
        }
    }

    private File assemblePidfile(String pidfileParm) {
        File pidfile = new File(pidfileParm);
        if (!pidfile.exists()) {
            throw new ValidatorProcessUsageException("-pidfile does not exist: '" + pidfileParm + "'");
        }
        if (!pidfile.canRead()) {
            throw new ValidatorProcessUsageException("-pidfile is not readable: '" + pidfileParm + "'");
        }
        return pidfile;
    }

    private Properties readLogConfigFile(String logConfigFilename) {
        Properties props = new Properties();
        if (logConfigFilename != null) {
            File propertiesFile = new File(logConfigFilename);
            if (!propertiesFile.exists()) {
                throw new ValidatorProcessUsageException("-logConfig file '" + logConfigFilename + "' does not exist.");
            }
            if (!propertiesFile.isFile() || !propertiesFile.canRead()) {
                throw new ValidatorProcessUsageException("-logConfig file '" + logConfigFilename + "' is not a readable file.");
            }
            try {
                props.load(new FileInputStream(propertiesFile));
            }
            catch (IOException e) {
                throw new ValidatorProcessUsageException("Failed to load properties from -logConfig file '" + logConfigFilename + "'");
            }
        }
        return props;
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public Properties getLogConfigProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.logConfigProperties);
        return props;
    }

    public IteratorType getIteratorType() {
        return this.iteratorType;
    }

    public FieldSearchQuery getQuery() {
        return this.fieldSearchQuery;
    }

    public File getPidfile() {
        return this.pidfile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IteratorType {
        FS_QUERY,
        PIDFILE;

    }
}

