/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.remote;

import fedora.client.FedoraClient;
import fedora.client.utility.validate.InvalidContentModelException;
import fedora.client.utility.validate.ObjectSource;
import fedora.client.utility.validate.ObjectSourceException;
import fedora.client.utility.validate.remote.RemotePidIterator;
import fedora.client.utility.validate.remote.ServiceInfo;
import fedora.client.utility.validate.remote.TypeUtility;
import fedora.client.utility.validate.types.BasicContentModelInfo;
import fedora.client.utility.validate.types.BasicObjectInfo;
import fedora.client.utility.validate.types.ContentModelInfo;
import fedora.client.utility.validate.types.DatastreamInfo;
import fedora.client.utility.validate.types.DsCompositeModelDoc;
import fedora.client.utility.validate.types.ObjectInfo;
import fedora.client.utility.validate.types.RelationshipInfo;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.search.FieldSearchQuery;
import fedora.server.types.gen.Datastream;
import fedora.server.types.gen.MIMETypedStream;
import fedora.server.types.gen.RelationshipTuple;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.rpc.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteObjectSource
implements ObjectSource {
    private final FedoraAPIA apia;
    private final FedoraAPIM apim;

    public RemoteObjectSource(ServiceInfo serviceInfo) throws ServiceException, IOException {
        FedoraClient fc = new FedoraClient(serviceInfo.getBaseUrlString(), serviceInfo.getUsername(), serviceInfo.getPassword());
        this.apia = fc.getAPIA();
        this.apim = fc.getAPIM();
    }

    public Iterator<String> findObjectPids(FieldSearchQuery query) throws ObjectSourceException {
        return new RemotePidIterator(this.apia, query);
    }

    @Override
    public ObjectInfo getValidationObject(String pid) throws ObjectSourceException {
        List<RelationshipInfo> relations = this.getRelationships(pid);
        Set<DatastreamInfo> dsDefs = this.getDatastreams(pid);
        return new BasicObjectInfo(pid, relations, dsDefs);
    }

    private Set<DatastreamInfo> getDatastreams(String pid) throws ObjectSourceException {
        try {
            Datastream[] datastreams = this.apim.getDatastreams(pid, null, null);
            return TypeUtility.convertGenDatastreamArrayToDatastreamInfoSet(datastreams);
        }
        catch (RemoteException e) {
            throw new ObjectSourceException(e);
        }
    }

    private List<RelationshipInfo> getRelationships(String pid) throws ObjectSourceException {
        try {
            RelationshipTuple[] tuples = this.apim.getRelationships(pid, null);
            return TypeUtility.convertGenRelsTupleArrayToRelationshipInfoList(tuples);
        }
        catch (RemoteException e) {
            throw new ObjectSourceException(e);
        }
    }

    @Override
    public ContentModelInfo getContentModelInfo(String pid) throws ObjectSourceException, InvalidContentModelException {
        try {
            ObjectInfo object = this.getValidationObject(pid);
            if (object == null) {
                return null;
            }
            DatastreamInfo dsInfo = object.getDatastreamInfo("DS-COMPOSITE-MODEL");
            if (dsInfo == null) {
                throw new InvalidContentModelException(pid, "Content model has no 'DS-COMPOSITE-MODEL' datastream.");
            }
            if (!"info:fedora/fedora-system:FedoraDSCompositeModel-1.0".equals(dsInfo.getFormatUri())) {
                throw new InvalidContentModelException(pid, "Datastream 'DS-COMPOSITE-MODEL' has incorrect format URI: '" + dsInfo.getFormatUri() + "'.");
            }
            MIMETypedStream ds = this.apia.getDatastreamDissemination(pid, "DS-COMPOSITE-MODEL", null);
            DsCompositeModelDoc model = new DsCompositeModelDoc(pid, ds.getStream());
            return new BasicContentModelInfo(object, model.getTypeModels());
        }
        catch (RemoteException e) {
            throw new ObjectSourceException("Problem fetching 'DS-COMPOSITE-MODEL' datastream for pid='" + pid + "'", e);
        }
    }
}

