/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.remote;

import fedora.client.utility.validate.ObjectSourceException;
import fedora.client.utility.validate.remote.TypeUtility;
import fedora.server.access.FedoraAPIA;
import fedora.server.search.ObjectFields;
import fedora.server.types.gen.FieldSearchQuery;
import fedora.server.types.gen.FieldSearchResult;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.axis.types.NonNegativeInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemotePidIterator
implements Iterator<String> {
    public static final String[] OBJECT_RESULT_FIELDS = new String[]{"pid"};
    public static final NonNegativeInteger MAX_FIND_RESULTS = new NonNegativeInteger("500");
    private static final String SEARCH_NOT_STARTED = "SearchNotStartedYet";
    private final FedoraAPIA apia;
    private final fedora.server.search.FieldSearchQuery query;
    private final List<String> stash = new ArrayList<String>();
    private String token = "SearchNotStartedYet";

    RemotePidIterator(FedoraAPIA apia, fedora.server.search.FieldSearchQuery query) {
        this.apia = apia;
        this.query = query;
    }

    @Override
    public boolean hasNext() {
        try {
            this.refreshStash();
            return !this.stash.isEmpty();
        }
        catch (ObjectSourceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            return this.stash.remove(0);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void refreshStash() throws ObjectSourceException {
        if (!this.stash.isEmpty()) {
            return;
        }
        try {
            if (SEARCH_NOT_STARTED.equals(this.token)) {
                this.beginSearch();
            } else if (this.token != null) {
                this.resumeSearch();
            }
        }
        catch (RemoteException e) {
            throw new ObjectSourceException(e);
        }
    }

    private void beginSearch() throws RemoteException {
        FieldSearchQuery genFieldSearchQuery = TypeUtility.convertFieldSearchQueryToGenFieldSearchQuery(this.query);
        FieldSearchResult searchResult = this.apia.findObjects(OBJECT_RESULT_FIELDS, MAX_FIND_RESULTS, genFieldSearchQuery);
        fedora.server.search.FieldSearchResult fsr = TypeUtility.convertGenFieldSearchResultToFieldSearchResult(searchResult);
        for (ObjectFields fields : fsr.objectFieldsList()) {
            this.stash.add(fields.getPid());
        }
        this.token = fsr.getToken();
    }

    private void resumeSearch() throws RemoteException {
        FieldSearchResult searchResult = this.apia.resumeFindObjects(this.token);
        fedora.server.search.FieldSearchResult fsr = TypeUtility.convertGenFieldSearchResultToFieldSearchResult(searchResult);
        for (ObjectFields fields : fsr.objectFieldsList()) {
            this.stash.add(fields.getPid());
        }
        this.token = fsr.getToken();
    }
}

