/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.remote;

import fedora.client.utility.validate.remote.BasicFieldSearchResult;
import fedora.client.utility.validate.types.DatastreamInfo;
import fedora.client.utility.validate.types.RelationshipInfo;
import fedora.server.search.FieldSearchResult;
import fedora.server.search.ObjectFields;
import fedora.server.types.gen.ComparisonOperator;
import fedora.server.types.gen.Condition;
import fedora.server.types.gen.Datastream;
import fedora.server.types.gen.FieldSearchQuery;
import fedora.server.types.gen.ListSession;
import fedora.server.types.gen.RelationshipTuple;
import fedora.server.utilities.DateUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtility {
    public static FieldSearchQuery convertFieldSearchQueryToGenFieldSearchQuery(fedora.server.search.FieldSearchQuery fsq) {
        Condition[] genConditions = fsq.getConditions() == null ? null : TypeUtility.convertConditionsListToGenConditionsArray(fsq.getConditions());
        return new FieldSearchQuery(genConditions, fsq.getTerms());
    }

    public static Condition[] convertConditionsListToGenConditionsArray(List<fedora.server.search.Condition> conditions) {
        ArrayList<Condition> genConditions = new ArrayList<Condition>();
        for (fedora.server.search.Condition condition : conditions) {
            genConditions.add(TypeUtility.convertConditionToGenCondition(condition));
        }
        return genConditions.toArray(new Condition[0]);
    }

    public static Condition convertConditionToGenCondition(fedora.server.search.Condition condition) {
        ComparisonOperator compOperator;
        String opAbbr = condition.getOperator().getAbbreviation();
        try {
            compOperator = ComparisonOperator.fromString(opAbbr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("unrecognized comparison operator string: '" + opAbbr + "'");
        }
        return new Condition(condition.getProperty(), compOperator, condition.getValue());
    }

    public static FieldSearchResult convertGenFieldSearchResultToFieldSearchResult(fedora.server.types.gen.FieldSearchResult fsr) {
        long completeListSize = 0L;
        long cursor = 0L;
        Date expirationDate = new Date(0L);
        String token = null;
        ListSession listSession = fsr.getListSession();
        if (listSession != null) {
            completeListSize = listSession.getCompleteListSize().longValue();
            cursor = listSession.getCursor().longValue();
            expirationDate = DateUtility.convertStringToDate(listSession.getExpirationDate());
            token = listSession.getToken();
        }
        List<ObjectFields> objectFields = TypeUtility.convertGenObjectFieldsArrayToObjectFieldsList(fsr.getResultList());
        return new BasicFieldSearchResult(completeListSize, cursor, expirationDate, token, objectFields);
    }

    public static List<ObjectFields> convertGenObjectFieldsArrayToObjectFieldsList(fedora.server.types.gen.ObjectFields[] objectFields) {
        ArrayList<ObjectFields> result = new ArrayList<ObjectFields>();
        for (fedora.server.types.gen.ObjectFields objectField : objectFields) {
            result.add(TypeUtility.convertGenObjectFieldsToObjectFields(objectField));
        }
        return result;
    }

    public static ObjectFields convertGenObjectFieldsToObjectFields(fedora.server.types.gen.ObjectFields source) {
        ObjectFields result = new ObjectFields();
        result.setPid(source.getPid());
        result.setLabel(source.getLabel());
        result.setState(source.getState());
        result.setOwnerId(source.getOwnerId());
        result.setCDate(DateUtility.convertStringToDate(source.getCDate()));
        result.setMDate(DateUtility.convertStringToDate(source.getMDate()));
        result.setDCMDate(DateUtility.convertStringToDate(source.getDcmDate()));
        result.titles().addAll(TypeUtility.convertStringArray(source.getTitle()));
        result.subjects().addAll(TypeUtility.convertStringArray(source.getSubject()));
        result.descriptions().addAll(TypeUtility.convertStringArray(source.getDescription()));
        result.publishers().addAll(TypeUtility.convertStringArray(source.getPublisher()));
        result.contributors().addAll(TypeUtility.convertStringArray(source.getContributor()));
        result.dates().addAll(TypeUtility.convertStringArray(source.getDate()));
        result.types().addAll(TypeUtility.convertStringArray(source.getType()));
        result.formats().addAll(TypeUtility.convertStringArray(source.getFormat()));
        result.identifiers().addAll(TypeUtility.convertStringArray(source.getIdentifier()));
        result.sources().addAll(TypeUtility.convertStringArray(source.getSource()));
        result.languages().addAll(TypeUtility.convertStringArray(source.getLanguage()));
        result.relations().addAll(TypeUtility.convertStringArray(source.getRelation()));
        result.coverages().addAll(TypeUtility.convertStringArray(source.getCoverage()));
        result.rights().addAll(TypeUtility.convertStringArray(source.getRights()));
        return result;
    }

    private static List<String> convertStringArray(String[] strings) {
        if (strings == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(strings);
    }

    public static List<RelationshipInfo> convertGenRelsTupleArrayToRelationshipInfoList(RelationshipTuple[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        ArrayList<RelationshipInfo> list = new ArrayList<RelationshipInfo>(array.length);
        for (RelationshipTuple genTuple : array) {
            list.add(TypeUtility.convertGenRelsTupleToRelationshipInfo(genTuple));
        }
        return list;
    }

    public static RelationshipInfo convertGenRelsTupleToRelationshipInfo(RelationshipTuple genTuple) {
        return new RelationshipInfo(genTuple.getPredicate(), genTuple.getObject());
    }

    public static Set<DatastreamInfo> convertGenDatastreamArrayToDatastreamInfoSet(Datastream[] genDss) {
        HashSet<DatastreamInfo> set = new HashSet<DatastreamInfo>(genDss.length);
        for (Datastream ds : genDss) {
            set.add(TypeUtility.convertGenDatastreamDefToDatastreamInfo(ds));
        }
        return set;
    }

    private static DatastreamInfo convertGenDatastreamDefToDatastreamInfo(Datastream ds) {
        return new DatastreamInfo(ds.getID(), ds.getMIMEType(), ds.getFormatURI());
    }

    private TypeUtility() {
    }
}

