/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.types;

import fedora.client.utility.validate.types.DatastreamInfo;
import fedora.client.utility.validate.types.ObjectInfo;
import fedora.client.utility.validate.types.RelationshipInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicObjectInfo
implements ObjectInfo {
    private final String pid;
    private final Set<RelationshipInfo> relations;
    private final Map<String, DatastreamInfo> datastreamMap;

    public BasicObjectInfo(String pid) {
        this(pid, new HashSet<RelationshipInfo>(), new HashSet<DatastreamInfo>());
    }

    public BasicObjectInfo(String pid, Collection<RelationshipInfo> relations, Collection<DatastreamInfo> datastreams) {
        if (pid == null) {
            throw new NullPointerException("'pid' may not be null");
        }
        if (relations == null) {
            throw new NullPointerException("'relations' may not be null");
        }
        if (datastreams == null) {
            throw new NullPointerException("'datastreams' may not be null");
        }
        this.pid = pid;
        this.relations = Collections.unmodifiableSet(new HashSet<RelationshipInfo>(relations));
        HashMap<String, DatastreamInfo> datastreamMap = new HashMap<String, DatastreamInfo>();
        for (DatastreamInfo dsInfo : datastreams) {
            datastreamMap.put(dsInfo.getId(), dsInfo);
        }
        this.datastreamMap = Collections.unmodifiableMap(datastreamMap);
    }

    @Override
    public String getPid() {
        return this.pid;
    }

    @Override
    public boolean hasRelation(String relationship) {
        if (relationship == null) {
            throw new NullPointerException("'relationship' may not be null.");
        }
        for (RelationshipInfo relation : this.relations) {
            if (!relationship.equals(relation.getPredicate())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<RelationshipInfo> getRelations(String relationship) {
        ArrayList<RelationshipInfo> result = new ArrayList<RelationshipInfo>();
        for (RelationshipInfo relation : this.relations) {
            if (!relationship.equals(relation.getPredicate())) continue;
            result.add(relation);
        }
        return result;
    }

    @Override
    public Collection<String> getDatastreamIds() {
        return new HashSet<String>(this.datastreamMap.keySet());
    }

    @Override
    public DatastreamInfo getDatastreamInfo(String dsId) {
        return this.datastreamMap.get(dsId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicObjectInfo that = (BasicObjectInfo)obj;
        return this.equivalent(this.pid, that.pid) && this.equivalent(this.datastreamMap, that.datastreamMap) && this.equivalent(this.relations, that.relations);
    }

    private boolean equivalent(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public int hashCode() {
        return this.hashIt(this.pid) ^ this.hashIt(this.datastreamMap) ^ this.hashIt(this.relations);
    }

    private int hashIt(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public String toString() {
        return "BasicObjectInfo[pid='" + this.pid + "', relations=" + this.relations + "', datastreamMap=" + this.datastreamMap + "]";
    }
}

