/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.types;

import fedora.client.utility.validate.InvalidContentModelException;
import fedora.client.utility.validate.types.ContentModelInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsCompositeModelDoc {
    private static final String ELEMENT_DS_TYPE_MODEL = "dsTypeModel";
    private final Set<DsTypeModel> typeModels;

    public DsCompositeModelDoc(String pid, byte[] bytes) throws InvalidContentModelException {
        Document doc = this.parseBytesToDocument(pid, bytes);
        NodeList typeModelNodes = doc.getElementsByTagName(ELEMENT_DS_TYPE_MODEL);
        HashSet<DsTypeModel> typeModels = new HashSet<DsTypeModel>();
        for (int i = 0; i < typeModelNodes.getLength(); ++i) {
            Element typeModelElement = (Element)typeModelNodes.item(i);
            typeModels.add(new DsTypeModel(pid, typeModelElement));
        }
        this.typeModels = Collections.unmodifiableSet(typeModels);
    }

    public Set<ContentModelInfo.DsTypeModel> getTypeModels() {
        return new HashSet<ContentModelInfo.DsTypeModel>(this.typeModels);
    }

    private Document parseBytesToDocument(String pid, byte[] bytes) throws InvalidContentModelException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(bytes));
        }
        catch (ParserConfigurationException e) {
            throw new InvalidContentModelException(pid, "Failed to parse DS-COMPOSITE-MODEL", e);
        }
        catch (SAXException e) {
            throw new InvalidContentModelException(pid, "Failed to parse DS-COMPOSITE-MODEL", e);
        }
        catch (IOException e) {
            throw new InvalidContentModelException(pid, "Failed to parse DS-COMPOSITE-MODEL", e);
        }
    }

    public static class Form
    implements ContentModelInfo.Form {
        private static final String ATTRIBUTE_MIME = "MIME";
        private static final String ATTRIBUTE_FORMAT_URI = "FORMAT_URI";
        private final String mime;
        private final String formatUri;

        public Form(Element formElement) {
            String mime = formElement.getAttribute(ATTRIBUTE_MIME);
            this.mime = mime.length() == 0 ? null : mime;
            String formatUri = formElement.getAttribute(ATTRIBUTE_FORMAT_URI);
            this.formatUri = formatUri.length() == 0 ? null : formatUri;
        }

        public String getMimeType() {
            return this.mime;
        }

        public String getFormatUri() {
            return this.formatUri;
        }

        public String toString() {
            return "Form[mime=" + this.mime + ", formatUri=" + this.formatUri + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DsTypeModel
    implements ContentModelInfo.DsTypeModel {
        private static final String ATTRIBUTE_ID = "ID";
        private static final String ELEMENT_FORM = "form";
        private final String id;
        private final Set<Form> forms;

        public DsTypeModel(String pid, Element typeModelElement) throws InvalidContentModelException {
            this.id = typeModelElement.getAttribute(ATTRIBUTE_ID);
            if (this.id.length() == 0) {
                throw new InvalidContentModelException(pid, "<dsTypeModel> has no 'ID'");
            }
            NodeList formNodes = typeModelElement.getElementsByTagName(ELEMENT_FORM);
            HashSet<Form> forms = new HashSet<Form>();
            for (int i = 0; i < formNodes.getLength(); ++i) {
                forms.add(new Form((Element)formNodes.item(i)));
            }
            this.forms = Collections.unmodifiableSet(forms);
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Set<ContentModelInfo.Form> getForms() {
            return new HashSet<ContentModelInfo.Form>(this.forms);
        }
    }
}

