/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.validate.types;

public class RelationshipInfo {
    private final String predicate;
    private final String object;

    public RelationshipInfo(String predicate, String object) {
        this.predicate = predicate;
        this.object = object;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public String getObject() {
        return this.object;
    }

    public String getObjectPid() {
        if (this.object != null && this.object.startsWith("info:fedora/")) {
            return this.object.substring(12);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        RelationshipInfo that = (RelationshipInfo)obj;
        return this.equivalent(this.predicate, that.predicate) && this.equivalent(this.object, that.object);
    }

    public int hashCode() {
        return this.hashIt(this.predicate) ^ this.hashIt(this.object);
    }

    public String toString() {
        return "RelationshipInfo[predicate='" + this.predicate + "', object='" + this.object + "']";
    }

    private boolean equivalent(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private int hashIt(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }
}

