/*
 * Decompiled with CFR 0.152.
 */
package fedora.common.policy;

import fedora.common.policy.XacmlNamespace;
import java.net.URI;
import java.net.URISyntaxException;
import org.jrdf.graph.TypedNodeVisitor;
import org.jrdf.graph.URIReference;

public class XacmlName
implements URIReference {
    private static final long serialVersionUID = 1L;
    public XacmlNamespace parent;
    public String localName;
    public String datatype;
    public String uri;
    private URI m_uri;

    public XacmlName(XacmlNamespace parent, String localName, String datatype) {
        try {
            this.parent = parent;
            this.localName = localName;
            this.datatype = datatype;
            this.uri = parent.uri + ":" + localName;
            this.m_uri = new URI(this.uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad URI Syntax", e);
        }
    }

    public XacmlName(XacmlNamespace parent, String localName) {
        this(parent, localName, "");
    }

    public boolean looselyMatches(String in, boolean tryFirstLocalNameChar) {
        if (in == null || in.length() == 0) {
            return false;
        }
        if (in.equalsIgnoreCase(this.localName)) {
            return true;
        }
        if (in.equals(this.uri)) {
            return true;
        }
        return tryFirstLocalNameChar && in.length() == 1 && in.toUpperCase().charAt(0) == this.localName.toUpperCase().charAt(0);
    }

    public void accept(TypedNodeVisitor visitor) {
        visitor.visitURIReference((URIReference)this);
    }

    public URI getURI() {
        return this.m_uri;
    }

    public String toString() {
        return this.uri + "\t" + this.datatype;
    }

    public String stringValue() {
        return this.toString();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.parent.toString();
    }
}

