/*
 * Decompiled with CFR 0.152.
 */
package fedora.server;

import fedora.common.Constants;
import fedora.common.FaultException;
import fedora.common.MalformedPIDException;
import fedora.common.PID;
import fedora.server.Context;
import fedora.server.DatastoreConfig;
import fedora.server.Module;
import fedora.server.Pluggable;
import fedora.server.config.ServerConfiguration;
import fedora.server.config.ServerConfigurationParser;
import fedora.server.errors.GeneralException;
import fedora.server.errors.MalformedPidException;
import fedora.server.errors.ModuleInitializationException;
import fedora.server.errors.ModuleShutdownException;
import fedora.server.errors.ServerInitializationException;
import fedora.server.errors.ServerShutdownException;
import fedora.server.errors.authorization.AuthzException;
import fedora.server.security.Authorization;
import fedora.server.utilities.DateUtility;
import fedora.server.utilities.status.ServerState;
import fedora.server.utilities.status.ServerStatusFile;
import fedora.utilities.Log4J;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Server
extends Pluggable {
    public static final boolean USE_CACHE = true;
    public static final boolean USE_DEFINITIVE_STORE = false;
    public static final boolean GLOBAL_CHOICE = false;
    private static Logger LOG;
    private static ResourceBundle s_const;
    public static String VERSION_MAJOR;
    public static String VERSION_MINOR;
    public static String BUILD_NUMBER;
    public static String HOME_PROPERTY;
    public static String STORAGE_FORMAT;
    public static String CONFIG_DIR;
    public static String LOG_STARTUP_FILE;
    public static String CONFIG_FILE;
    public static String EXTENSION_DIR;
    public static String BIN_DIR;
    public static String NAMESPACE_PREFIX;
    public static String CONFIG_NAMESPACE;
    public static String CONFIG_ELEMENT_ROOT;
    public static String CONFIG_ELEMENT_COMMENT;
    public static String CONFIG_ELEMENT_DATASTORE;
    public static String CONFIG_ELEMENT_MODULE;
    public static String CONFIG_ELEMENT_PARAM;
    public static String CONFIG_ATTRIBUTE_CLASS;
    public static String CONFIG_ATTRIBUTE_ROLE;
    public static String CONFIG_ATTRIBUTE_NAME;
    public static String CONFIG_ATTRIBUTE_VALUE;
    public static String CONFIG_ATTRIBUTE_ID;
    public static String SERVER_CONSTRUCTOR_PARAM1_CLASS;
    public static String SERVER_CONSTRUCTOR_PARAM2_CLASS;
    public static String MODULE_CONSTRUCTOR_PARAM1_CLASS;
    public static String MODULE_CONSTRUCTOR_PARAM2_CLASS;
    public static String MODULE_CONSTRUCTOR_PARAM3_CLASS;
    public static String DEFAULT_SERVER_CLASS;
    public static String INIT_XMLPARSER_SEVERE_MISSING;
    public static String INIT_CONFIG_SEVERE_UNREADABLE;
    public static String INIT_CONFIG_SEVERE_MALFORMEDXML;
    public static String INIT_CONFIG_SEVERE_BADROOTELEMENT;
    public static String INIT_CONFIG_SEVERE_BADELEMENT;
    public static String INIT_CONFIG_SEVERE_NOIDGIVEN;
    public static String INIT_CONFIG_SEVERE_BADNAMESPACE;
    public static String INIT_CONFIG_SEVERE_NOROLEGIVEN;
    public static String INIT_CONFIG_SEVERE_NOCLASSGIVEN;
    public static String INIT_CONFIG_SEVERE_REASSIGNMENT;
    public static String INIT_CONFIG_SEVERE_INCOMPLETEPARAM;
    public static String INIT_CONFIG_CONFIG_EXAMININGELEMENT;
    public static String INIT_CONFIG_CONFIG_PARAMETERIS;
    public static String INIT_SERVER_SEVERE_CLASSNOTFOUND;
    public static String INIT_SERVER_SEVERE_ILLEGALACCESS;
    public static String INIT_SERVER_SEVERE_BADARGS;
    public static String INIT_SERVER_SEVERE_MISSINGCONSTRUCTOR;
    public static String INIT_SERVER_SEVERE_UNFULFILLEDROLE;
    public static String INIT_MODULE_SEVERE_UNFULFILLEDROLE;
    public static String INIT_SERVER_SEVERE_ISABSTRACT;
    public static String INIT_MODULE_SEVERE_CLASSNOTFOUND;
    public static String INIT_MODULE_SEVERE_ILLEGALACCESS;
    public static String INIT_MODULE_SEVERE_BADARGS;
    public static String INIT_MODULE_SEVERE_MISSINGCONSTRUCTOR;
    public static String INIT_MODULE_SEVERE_ISABSTRACT;
    public static String INIT_LOG_WARNING_CANTWRITESTARTUPLOG;
    private static Locale s_locale;
    protected static HashMap s_instances;
    private File m_homeDir;
    private HashMap m_datastoreConfigs;
    private HashMap m_loadedModules;
    private ArrayList m_startupLogRecords;
    private boolean m_initialized;
    private ServerStatusFile m_statusFile;
    private static String s_serverProfile;

    protected Server(Element rootConfigElement, File homeDir) throws ServerInitializationException, ModuleInitializationException {
        try {
            String[] reqRoles;
            this.m_initialized = false;
            this.m_startupLogRecords = new ArrayList();
            this.m_loadedModules = new HashMap();
            this.m_homeDir = new File(homeDir, "server");
            this.m_statusFile = new ServerStatusFile(this.m_homeDir);
            File logDir = new File(this.m_homeDir, "logs");
            if (!logDir.exists()) {
                logDir.mkdir();
            }
            File configFile = new File(this.m_homeDir + File.separator + CONFIG_DIR + File.separator + CONFIG_FILE);
            LOG.info((Object)("Server home is " + this.m_homeDir.toString()));
            if (s_serverProfile == null) {
                LOG.debug((Object)"fedora.serverProfile property not set... will always use param 'value' attributes from configuration for param values.");
            } else {
                LOG.debug((Object)("fedora.serverProfile property was '" + s_serverProfile + "'... will use param '" + s_serverProfile + "value' attributes from " + "configuration for param values, falling back to " + "'value' attributes where unspecified."));
            }
            LOG.debug((Object)("Loading and validating configuration file \"" + configFile + "\""));
            HashMap serverParams = this.loadParameters(rootConfigElement, "");
            ArrayList mdInfo = (ArrayList)serverParams.get(null);
            HashMap moduleParams = (HashMap)mdInfo.get(0);
            HashMap moduleClassNames = (HashMap)mdInfo.get(1);
            HashMap datastoreParams = (HashMap)mdInfo.get(2);
            serverParams.remove(null);
            this.setParameters(serverParams);
            for (String element : reqRoles = this.getRequiredModuleRoles()) {
                if (moduleParams.get(element) != null) continue;
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_UNFULFILLEDROLE, element));
            }
            this.m_statusFile.append(ServerState.STARTING, "Initializing Server");
            this.initServer();
            Iterator dspi = datastoreParams.keySet().iterator();
            this.m_datastoreConfigs = new HashMap();
            while (dspi.hasNext()) {
                String id = (String)dspi.next();
                this.m_datastoreConfigs.put(id, new DatastoreConfig((Map)((HashMap)datastoreParams.get(id))));
            }
            this.m_statusFile.append(ServerState.STARTING, "Initializing Modules");
            for (String role : moduleParams.keySet()) {
                String className = (String)moduleClassNames.get(role);
                LOG.info((Object)("Initializing " + className));
                try {
                    Class<?> moduleClass = Class.forName(className);
                    Class<?> param1Class = Class.forName(MODULE_CONSTRUCTOR_PARAM1_CLASS);
                    Class<?> param2Class = Class.forName(MODULE_CONSTRUCTOR_PARAM2_CLASS);
                    Class<?> param3Class = Class.forName(MODULE_CONSTRUCTOR_PARAM3_CLASS);
                    LOG.debug((Object)("Getting constructor " + className + "(" + MODULE_CONSTRUCTOR_PARAM1_CLASS + "," + MODULE_CONSTRUCTOR_PARAM2_CLASS + "," + MODULE_CONSTRUCTOR_PARAM3_CLASS + ")"));
                    Constructor<?> moduleConstructor = moduleClass.getConstructor(param1Class, param2Class, param3Class);
                    Module inst = (Module)moduleConstructor.newInstance(moduleParams.get(role), this, role);
                    this.m_loadedModules.put(role, inst);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ModuleInitializationException(MessageFormat.format(INIT_MODULE_SEVERE_CLASSNOTFOUND, className), role);
                }
                catch (IllegalAccessException iae) {
                    throw new ModuleInitializationException(MessageFormat.format(INIT_MODULE_SEVERE_ILLEGALACCESS, className), role);
                }
                catch (IllegalArgumentException iae) {
                    throw new ModuleInitializationException(MessageFormat.format(INIT_MODULE_SEVERE_BADARGS, className), role);
                }
                catch (InstantiationException ie) {
                    throw new ModuleInitializationException(MessageFormat.format(INIT_MODULE_SEVERE_MISSINGCONSTRUCTOR, className), role);
                }
                catch (NoSuchMethodException nsme) {
                    throw new ModuleInitializationException(MessageFormat.format(INIT_MODULE_SEVERE_ISABSTRACT, className), role);
                }
                catch (InvocationTargetException ite) {
                    try {
                        throw ite.getCause();
                    }
                    catch (ModuleInitializationException mie) {
                        throw mie;
                    }
                    catch (Throwable t) {
                        StringBuffer s = new StringBuffer();
                        s.append(t.getClass().getName());
                        s.append(": ");
                        for (int i = 0; i < t.getStackTrace().length; ++i) {
                            s.append(t.getStackTrace()[i] + "\n");
                        }
                        throw new ModuleInitializationException(s.toString(), role);
                    }
                }
            }
            this.m_statusFile.append(ServerState.STARTING, "Post-Initializing Modules");
            for (String r : moduleParams.keySet()) {
                Module m = this.getModule(r);
                LOG.info((Object)("Post-Initializing " + m.getClass().getName()));
                reqRoles = m.getRequiredModuleRoles();
                LOG.debug((Object)"verifying dependencies have been loaded...");
                for (String element : reqRoles) {
                    if (this.getModule(element) != null) continue;
                    throw new ModuleInitializationException(MessageFormat.format(INIT_MODULE_SEVERE_UNFULFILLEDROLE, element), r);
                }
                LOG.debug((Object)(reqRoles.length + " dependencies, all loaded, ok."));
                m.postInitModule();
            }
            LOG.debug((Object)"Post-initializing server");
            this.postInitServer();
            LOG.info((Object)"Server startup complete");
            this.m_initialized = true;
        }
        catch (ServerInitializationException sie) {
            LOG.fatal((Object)"Server failed to initialize", (Throwable)sie);
            try {
                this.shutdown(null);
            }
            catch (Throwable th) {
                LOG.warn((Object)"Error shutting down server after failed startup", th);
            }
            throw sie;
        }
        catch (ModuleInitializationException mie) {
            LOG.fatal((Object)("Module (" + mie.getRole() + ") failed to initialize"), (Throwable)mie);
            try {
                this.shutdown(null);
            }
            catch (Throwable th) {
                LOG.warn((Object)"Error shutting down server after failed startup", th);
            }
            throw mie;
        }
        catch (Throwable th) {
            String msg = "Fatal error while starting server";
            LOG.fatal((Object)msg, th);
            try {
                this.shutdown(null);
            }
            catch (Throwable oth) {
                LOG.warn((Object)"Error shutting down server after failed startup", oth);
            }
            throw new RuntimeException(msg, th);
        }
    }

    private static final String getStackTrace(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    protected boolean overrideModuleRole(String moduleRole) {
        return false;
    }

    protected String overrideModuleClass(String moduleClass) {
        return null;
    }

    protected static void configureLog4J(String extension) throws ServerInitializationException {
        File fedoraHome = new File(Constants.FEDORA_HOME);
        File serverDir = new File(fedoraHome, "server");
        File logDir = new File(serverDir, "logs");
        logDir.mkdirs();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("logDir", logDir.getPath());
        options.put("extension", extension);
        File propFile = new File(serverDir, "config/log4j.properties");
        try {
            Log4J.initFromPropFile(propFile, options);
        }
        catch (Exception e) {
            throw new ServerInitializationException("Error initializing from log4j configuration file: " + propFile.getPath(), e);
        }
        LOG = Logger.getLogger((String)Server.class.getName());
    }

    private final HashMap loadParameters(Element element, String dAttribute) throws ServerInitializationException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (element.getLocalName().equals(CONFIG_ELEMENT_ROOT)) {
            ArrayList moduleAndDatastreamInfo = new ArrayList(3);
            moduleAndDatastreamInfo.add(new HashMap());
            moduleAndDatastreamInfo.add(new HashMap());
            moduleAndDatastreamInfo.add(new HashMap());
            params.put(null, moduleAndDatastreamInfo);
        }
        LOG.debug((Object)MessageFormat.format(INIT_CONFIG_CONFIG_EXAMININGELEMENT, element.getLocalName(), dAttribute));
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            NamedNodeMap attrs;
            Node n = element.getChildNodes().item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getLocalName().equals(CONFIG_ELEMENT_PARAM)) {
                attrs = n.getAttributes();
                Node nameNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_NAME);
                if (nameNode == null) {
                    nameNode = attrs.getNamedItem(CONFIG_ATTRIBUTE_NAME);
                }
                Node valueNode = null;
                if (s_serverProfile != null && (valueNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, s_serverProfile + "value")) == null) {
                    valueNode = attrs.getNamedItem(s_serverProfile + "value");
                }
                if (valueNode == null) {
                    valueNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_VALUE);
                    if (valueNode == null) {
                        valueNode = attrs.getNamedItem(CONFIG_ATTRIBUTE_VALUE);
                    }
                    if (nameNode == null || valueNode == null) {
                        throw new ServerInitializationException(INIT_CONFIG_SEVERE_INCOMPLETEPARAM);
                    }
                }
                if (nameNode.getNodeValue().equals("") || valueNode.getNodeValue().equals("")) {
                    throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_INCOMPLETEPARAM, CONFIG_ELEMENT_PARAM, CONFIG_ATTRIBUTE_NAME, CONFIG_ATTRIBUTE_VALUE));
                }
                if (params.get(nameNode.getNodeValue()) != null) {
                    throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_REASSIGNMENT, CONFIG_ELEMENT_PARAM, CONFIG_ATTRIBUTE_NAME, nameNode.getNodeValue()));
                }
                params.put(nameNode.getNodeValue(), valueNode.getNodeValue());
                LOG.debug((Object)MessageFormat.format(INIT_CONFIG_CONFIG_PARAMETERIS, nameNode.getNodeValue(), valueNode.getNodeValue()));
                continue;
            }
            if (n.getLocalName().equals(CONFIG_ELEMENT_COMMENT) || !element.getLocalName().equals(CONFIG_ELEMENT_ROOT)) continue;
            if (n.getLocalName().equals(CONFIG_ELEMENT_MODULE)) {
                attrs = n.getAttributes();
                Node roleNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_ROLE);
                if (roleNode == null && (roleNode = attrs.getNamedItem(CONFIG_ATTRIBUTE_ROLE)) == null) {
                    throw new ServerInitializationException(INIT_CONFIG_SEVERE_NOROLEGIVEN);
                }
                String moduleRole = roleNode.getNodeValue();
                if (moduleRole.equals("")) {
                    throw new ServerInitializationException(INIT_CONFIG_SEVERE_NOROLEGIVEN);
                }
                if (this.overrideModuleRole(moduleRole)) continue;
                HashMap moduleImplHash = (HashMap)((ArrayList)params.get(null)).get(1);
                if (moduleImplHash.get(moduleRole) != null) {
                    throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_REASSIGNMENT, CONFIG_ELEMENT_MODULE, CONFIG_ATTRIBUTE_ROLE, moduleRole));
                }
                Node classNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_CLASS);
                if (classNode == null && (classNode = attrs.getNamedItem(CONFIG_ATTRIBUTE_CLASS)) == null) {
                    throw new ServerInitializationException(INIT_CONFIG_SEVERE_NOCLASSGIVEN);
                }
                String moduleClass = classNode.getNodeValue();
                if (this.overrideModuleClass(moduleClass) != null) {
                    moduleClass = this.overrideModuleClass(moduleClass);
                }
                if (moduleClass.equals("")) {
                    throw new ServerInitializationException(INIT_CONFIG_SEVERE_NOCLASSGIVEN);
                }
                moduleImplHash.put(moduleRole, moduleClass);
                ((HashMap)((ArrayList)params.get(null)).get(0)).put(moduleRole, this.loadParameters((Element)n, CONFIG_ATTRIBUTE_ROLE + "=\"" + moduleRole + "\""));
                continue;
            }
            if (n.getLocalName().equals(CONFIG_ELEMENT_DATASTORE)) {
                attrs = n.getAttributes();
                Node idNode = attrs.getNamedItemNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_ID);
                if (idNode == null && (idNode = attrs.getNamedItem(CONFIG_ATTRIBUTE_ID)) == null) {
                    throw new ServerInitializationException(INIT_CONFIG_SEVERE_NOIDGIVEN);
                }
                String dConfigId = idNode.getNodeValue();
                if (dConfigId.equals("")) {
                    throw new ServerInitializationException(INIT_CONFIG_SEVERE_NOIDGIVEN);
                }
                HashMap dParamHash = (HashMap)((ArrayList)params.get(null)).get(2);
                if (dParamHash.get(dConfigId) != null) {
                    throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_REASSIGNMENT, CONFIG_ELEMENT_DATASTORE, CONFIG_ATTRIBUTE_ID, dConfigId));
                }
                dParamHash.put(dConfigId, this.loadParameters((Element)n, CONFIG_ATTRIBUTE_ID + "=\"" + dConfigId + "\""));
                continue;
            }
            throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_BADELEMENT, n.getLocalName()));
        }
        return params;
    }

    public final boolean hasInitialized() {
        return this.m_initialized;
    }

    public ServerStatusFile getStatusFile() {
        return this.m_statusFile;
    }

    public static final boolean hasInstance(File homeDir) {
        return s_instances.get(homeDir) != null;
    }

    public final String status(Context context) throws AuthzException {
        ((Authorization)((Object)this.getModule("fedora.server.security.Authorization"))).enforceServerStatus(context);
        return "RUNNING";
    }

    public static final Server getInstance(File homeDir, boolean okToStart) throws ServerInitializationException, ModuleInitializationException {
        if (okToStart) {
            return Server.getInstance(homeDir);
        }
        Server instance = (Server)s_instances.get(homeDir);
        if (instance == null) {
            throw new ServerInitializationException("The Fedora server is not yet running.");
        }
        return instance;
    }

    public static final synchronized Server getInstance(File homeDir) throws ServerInitializationException, ModuleInitializationException {
        Server instance = (Server)s_instances.get(homeDir);
        if (instance != null) {
            return instance;
        }
        Server.configureLog4J(".log");
        LOG.info((Object)"Starting up server");
        File configFile = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            configFile = new File(homeDir + File.separator + "server" + File.separator + CONFIG_DIR + File.separator + CONFIG_FILE);
            Element rootElement = builder.parse(configFile).getDocumentElement();
            if (!rootElement.getLocalName().equals(CONFIG_ELEMENT_ROOT)) {
                throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_BADROOTELEMENT, configFile, CONFIG_ELEMENT_ROOT, rootElement.getLocalName()));
            }
            if (!rootElement.getNamespaceURI().equals(CONFIG_NAMESPACE)) {
                throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_BADNAMESPACE, configFile, CONFIG_NAMESPACE));
            }
            String className = rootElement.getAttribute(CONFIG_ATTRIBUTE_CLASS);
            if (className.equals("") && (className = rootElement.getAttributeNS(CONFIG_NAMESPACE, CONFIG_ATTRIBUTE_CLASS)).equals("")) {
                className = DEFAULT_SERVER_CLASS;
            }
            try {
                Class<?> serverClass = Class.forName(className);
                Class<?> param1Class = Class.forName(SERVER_CONSTRUCTOR_PARAM1_CLASS);
                Class<?> param2Class = Class.forName(SERVER_CONSTRUCTOR_PARAM2_CLASS);
                Constructor<?> serverConstructor = serverClass.getConstructor(param1Class, param2Class);
                Server inst = (Server)serverConstructor.newInstance(rootElement, homeDir);
                s_instances.put(homeDir, inst);
                return inst;
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_CLASSNOTFOUND, className));
            }
            catch (IllegalAccessException iae) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_ILLEGALACCESS, className));
            }
            catch (IllegalArgumentException iae) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_BADARGS, className));
            }
            catch (InstantiationException ie) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_MISSINGCONSTRUCTOR, className));
            }
            catch (NoSuchMethodException nsme) {
                throw new ServerInitializationException(MessageFormat.format(INIT_SERVER_SEVERE_ISABSTRACT, className));
            }
            catch (InvocationTargetException ite) {
                try {
                    throw ite.getCause();
                }
                catch (ServerInitializationException sie) {
                    throw sie;
                }
                catch (ModuleInitializationException mie) {
                    throw mie;
                }
                catch (Throwable t) {
                    StringBuffer s = new StringBuffer();
                    s.append(t.getClass().getName());
                    s.append(": ");
                    for (int i = 0; i < t.getStackTrace().length; ++i) {
                        s.append(t.getStackTrace()[i] + "\n");
                    }
                    throw new ServerInitializationException(s.toString());
                }
            }
        }
        catch (ParserConfigurationException pce) {
            throw new ServerInitializationException(INIT_XMLPARSER_SEVERE_MISSING);
        }
        catch (FactoryConfigurationError fce) {
            throw new ServerInitializationException(INIT_XMLPARSER_SEVERE_MISSING);
        }
        catch (IOException ioe) {
            throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_UNREADABLE, configFile, ioe.getMessage()));
        }
        catch (IllegalArgumentException iae) {
            throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_UNREADABLE, configFile, iae.getMessage()));
        }
        catch (SAXException saxe) {
            throw new ServerInitializationException(MessageFormat.format(INIT_CONFIG_SEVERE_MALFORMEDXML, configFile, saxe.getMessage()));
        }
    }

    public final File getHomeDir() {
        return this.m_homeDir;
    }

    public final Module getModule(String role) {
        return (Module)this.m_loadedModules.get(role);
    }

    public final DatastoreConfig getDatastoreConfig(String id) {
        return (DatastoreConfig)this.m_datastoreConfigs.get(id);
    }

    public Iterator datastoreConfigIds() {
        return this.m_datastoreConfigs.keySet().iterator();
    }

    public final Iterator loadedModuleRoles() {
        return this.m_loadedModules.keySet().iterator();
    }

    protected void initServer() throws ServerInitializationException {
    }

    protected void postInitServer() throws ServerInitializationException {
    }

    public final void shutdown(Context context) throws ServerShutdownException, ModuleShutdownException, AuthzException {
        Iterator roleIterator = this.loadedModuleRoles();
        LOG.info((Object)"Shutting down server");
        ModuleShutdownException mse = null;
        while (roleIterator.hasNext()) {
            Module m = this.getModule((String)roleIterator.next());
            String mName = m.getClass().getName();
            try {
                LOG.info((Object)("Shutting down " + mName));
                m.shutdownModule();
            }
            catch (ModuleShutdownException e) {
                LOG.warn((Object)("Error shutting down module " + mName), (Throwable)e);
                mse = e;
            }
        }
        this.shutdownServer();
        LOG.info((Object)"Server shutdown complete");
        s_instances.remove(this.getHomeDir());
        if (mse != null) {
            throw mse;
        }
    }

    protected void shutdownServer() throws ServerShutdownException {
    }

    public final void finalize() throws ServerShutdownException, ModuleShutdownException {
        this.shutdownServer();
    }

    public static final Locale getLocale() {
        if (s_locale == null) {
            String language = System.getProperty("locale.language");
            String country = System.getProperty("locale.country");
            String variant = System.getProperty("locale.variant");
            s_locale = language != null && country != null ? (variant != null ? new Locale(language, country, variant) : new Locale(language, country)) : Locale.getDefault();
        }
        return s_locale;
    }

    public String getConfigSummary() {
        int i;
        StringBuffer out = new StringBuffer();
        out.append("[ Fedora Server Configuration Summary ]\n\n");
        out.append("Server class     : " + this.getClass().getName() + "\n");
        out.append("Required modules : ");
        String padding = "                   ";
        String[] roles = this.getRequiredModuleRoles();
        if (roles.length == 0) {
            out.append("<none>\n");
        } else {
            for (i = 0; i < roles.length; ++i) {
                if (i > 0) {
                    out.append(padding);
                }
                out.append(roles[i] + "\n");
            }
        }
        out.append("Parameters       : ");
        Iterator iter = this.parameterNames();
        i = 0;
        while (iter.hasNext()) {
            String name = iter.next();
            String value = this.getParameter(name);
            if (i > 0) {
                out.append(padding);
            }
            out.append(name + "=" + value + "\n");
            ++i;
        }
        if (i == 0) {
            out.append("<none>\n");
        }
        iter = this.loadedModuleRoles();
        while (iter.hasNext()) {
            String role = (String)iter.next();
            out.append("\nLoaded Module : " + role + "\n");
            Module module = this.getModule(role);
            out.append("Class         : " + module.getClass().getName() + "\n");
            out.append("Dependencies  : " + module.getRequiredModuleRoles().length + "\n");
            for (i = 0; i < module.getRequiredModuleRoles().length; ++i) {
                out.append("Dependency    : " + module.getRequiredModuleRoles()[i] + "\n");
            }
            out.append("Parameters    : ");
            padding = "                ";
            i = 0;
            Iterator<String> iter2 = module.parameterNames();
            while (iter2.hasNext()) {
                String name = iter2.next();
                String value = module.getParameter(name);
                if (i > 0) {
                    out.append(padding);
                }
                out.append(name + "=" + value + "\n");
                ++i;
            }
            if (i != 0) continue;
            out.append("<none>\n");
        }
        iter = this.datastoreConfigIds();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            out.append("\nDatastore Cfg : " + id + "\n");
            out.append("Parameters    : ");
            padding = "                ";
            i = 0;
            Iterator<String> iter2 = this.getDatastoreConfig(id).parameterNames();
            while (iter2.hasNext()) {
                String name = iter2.next();
                String value = this.getDatastoreConfig(id).getParameter(name);
                if (i > 0) {
                    out.append(padding);
                }
                out.append(name + "=" + value + "\n");
                ++i;
            }
            if (i != 0) continue;
            out.append("<none>\n");
        }
        return out.toString();
    }

    public static PID getPID(String pidString) throws MalformedPidException {
        try {
            return new PID(pidString);
        }
        catch (MalformedPIDException e) {
            throw new MalformedPidException(e.getMessage());
        }
    }

    public static PID pidFromFilename(String filename) throws MalformedPidException {
        try {
            return PID.fromFilename(filename);
        }
        catch (MalformedPIDException e) {
            throw new MalformedPidException(e.getMessage());
        }
    }

    public static Date getCurrentDate(Context context) throws GeneralException {
        String propName = Constants.ENVIRONMENT.CURRENT_DATE_TIME.uri;
        String dateTimeValue = context.getEnvironmentValue(propName);
        if (dateTimeValue == null) {
            throw new GeneralException("Missing value for environment context attribute: " + propName);
        }
        Date currentDate = DateUtility.convertStringToDate(dateTimeValue);
        if (currentDate == null) {
            throw new GeneralException("Unparsable dateTime string: '" + dateTimeValue + "'");
        }
        return currentDate;
    }

    public static ServerConfiguration getConfig() {
        try {
            FileInputStream fcfg = new FileInputStream(new File(Constants.FEDORA_HOME, "server/config/fedora.fcfg"));
            ServerConfigurationParser parser = new ServerConfigurationParser(fcfg);
            return parser.parse();
        }
        catch (IOException e) {
            throw new FaultException("Error loading server configuration", e);
        }
    }

    static {
        s_const = ResourceBundle.getBundle("fedora.server.resources.Server");
        VERSION_MAJOR = s_const.getString("version.major");
        VERSION_MINOR = s_const.getString("version.minor");
        BUILD_NUMBER = s_const.getString("version.buildNumber");
        HOME_PROPERTY = s_const.getString("home.property");
        STORAGE_FORMAT = s_const.getString("format.storage");
        CONFIG_DIR = s_const.getString("config.dir");
        LOG_STARTUP_FILE = s_const.getString("log.startup.file");
        CONFIG_FILE = s_const.getString("config.file");
        EXTENSION_DIR = s_const.getString("extension.dir");
        BIN_DIR = s_const.getString("bin.dir");
        NAMESPACE_PREFIX = MessageFormat.format(s_const.getString("namespace.prefix"), "1", "0");
        CONFIG_NAMESPACE = MessageFormat.format(s_const.getString("config.namespace"), NAMESPACE_PREFIX);
        CONFIG_ELEMENT_ROOT = s_const.getString("config.element.root");
        CONFIG_ELEMENT_COMMENT = s_const.getString("config.element.comment");
        CONFIG_ELEMENT_DATASTORE = s_const.getString("config.element.datastore");
        CONFIG_ELEMENT_MODULE = s_const.getString("config.element.module");
        CONFIG_ELEMENT_PARAM = s_const.getString("config.element.param");
        CONFIG_ATTRIBUTE_CLASS = s_const.getString("config.attribute.class");
        CONFIG_ATTRIBUTE_ROLE = s_const.getString("config.attribute.role");
        CONFIG_ATTRIBUTE_NAME = s_const.getString("config.attribute.name");
        CONFIG_ATTRIBUTE_VALUE = s_const.getString("config.attribute.value");
        CONFIG_ATTRIBUTE_ID = s_const.getString("config.attribute.id");
        SERVER_CONSTRUCTOR_PARAM1_CLASS = s_const.getString("server.constructor.param1.class");
        SERVER_CONSTRUCTOR_PARAM2_CLASS = s_const.getString("server.constructor.param2.class");
        MODULE_CONSTRUCTOR_PARAM1_CLASS = s_const.getString("module.constructor.param1.class");
        MODULE_CONSTRUCTOR_PARAM2_CLASS = s_const.getString("module.constructor.param2.class");
        MODULE_CONSTRUCTOR_PARAM3_CLASS = s_const.getString("module.constructor.param3.class");
        DEFAULT_SERVER_CLASS = s_const.getString("default.server.class");
        INIT_XMLPARSER_SEVERE_MISSING = s_const.getString("init.xmlparser.severe.missing");
        INIT_CONFIG_SEVERE_UNREADABLE = s_const.getString("init.config.severe.unreadable");
        INIT_CONFIG_SEVERE_MALFORMEDXML = s_const.getString("init.config.severe.malformedxml");
        INIT_CONFIG_SEVERE_BADROOTELEMENT = s_const.getString("init.config.severe.badrootelement");
        INIT_CONFIG_SEVERE_BADELEMENT = s_const.getString("init.config.severe.badelement");
        INIT_CONFIG_SEVERE_NOIDGIVEN = MessageFormat.format(s_const.getString("init.config.severe.noidgiven"), CONFIG_ELEMENT_DATASTORE, CONFIG_ATTRIBUTE_ID);
        INIT_CONFIG_SEVERE_BADNAMESPACE = s_const.getString("init.config.severe.badnamespace");
        INIT_CONFIG_SEVERE_NOROLEGIVEN = MessageFormat.format(s_const.getString("init.config.severe.norolegiven"), CONFIG_ELEMENT_MODULE, CONFIG_ATTRIBUTE_ROLE);
        INIT_CONFIG_SEVERE_NOCLASSGIVEN = MessageFormat.format(s_const.getString("init.config.severe.noclassgiven"), CONFIG_ELEMENT_MODULE, CONFIG_ATTRIBUTE_CLASS);
        INIT_CONFIG_SEVERE_REASSIGNMENT = s_const.getString("init.config.severe.reassignment");
        INIT_CONFIG_SEVERE_INCOMPLETEPARAM = MessageFormat.format(s_const.getString("init.config.severe.incompleteparam"), CONFIG_ELEMENT_PARAM, CONFIG_ATTRIBUTE_NAME, CONFIG_ATTRIBUTE_VALUE);
        INIT_CONFIG_CONFIG_EXAMININGELEMENT = s_const.getString("init.config.config.examiningelement");
        INIT_CONFIG_CONFIG_PARAMETERIS = s_const.getString("init.config.config.parameteris");
        INIT_SERVER_SEVERE_CLASSNOTFOUND = s_const.getString("init.server.severe.classnotfound");
        INIT_SERVER_SEVERE_ILLEGALACCESS = s_const.getString("init.server.severe.illegalaccess");
        INIT_SERVER_SEVERE_BADARGS = s_const.getString("init.server.severe.badargs");
        INIT_SERVER_SEVERE_MISSINGCONSTRUCTOR = s_const.getString("init.server.severe.missingconstructor");
        INIT_SERVER_SEVERE_UNFULFILLEDROLE = s_const.getString("init.server.severe.unfulfilledrole");
        INIT_MODULE_SEVERE_UNFULFILLEDROLE = s_const.getString("init.module.severe.unfulfilledrole");
        INIT_SERVER_SEVERE_ISABSTRACT = s_const.getString("init.server.severe.isabstract");
        INIT_MODULE_SEVERE_CLASSNOTFOUND = s_const.getString("init.module.severe.classnotfound");
        INIT_MODULE_SEVERE_ILLEGALACCESS = s_const.getString("init.module.severe.illegalaccess");
        INIT_MODULE_SEVERE_BADARGS = s_const.getString("init.module.severe.badargs");
        INIT_MODULE_SEVERE_MISSINGCONSTRUCTOR = s_const.getString("init.module.severe.missingconstructor");
        INIT_MODULE_SEVERE_ISABSTRACT = s_const.getString("init.module.severe.isabstract");
        INIT_LOG_WARNING_CANTWRITESTARTUPLOG = s_const.getString("init.log.warning.cantwritestartuplog");
        s_instances = new HashMap();
        s_serverProfile = System.getProperty("fedora.serverProfile");
    }
}

