/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.config;

import fedora.common.Constants;
import fedora.server.config.Configuration;
import fedora.server.config.DatastoreConfiguration;
import fedora.server.config.ModuleConfiguration;
import fedora.server.config.Parameter;
import fedora.server.config.ServerConfigurationParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfiguration
extends Configuration
implements Constants {
    private String m_className;
    private final List<ModuleConfiguration> m_moduleConfigurations;
    private final List<DatastoreConfiguration> m_datastoreConfigurations;

    public ServerConfiguration(String className, List<Parameter> parameters, List<ModuleConfiguration> moduleConfigurations, List<DatastoreConfiguration> datastoreConfigurations) {
        super(parameters);
        this.m_className = className;
        this.m_moduleConfigurations = moduleConfigurations;
        this.m_datastoreConfigurations = datastoreConfigurations;
    }

    public ServerConfiguration copy() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serialize(out);
        return new ServerConfigurationParser(new ByteArrayInputStream(out.toByteArray())).parse();
    }

    public void applyProperties(Properties props) {
        for (String string : props.keySet()) {
            String value = props.getProperty(string).trim();
            if (string.indexOf(":") == -1 || value == null || value.length() <= 0) continue;
            String name = string.substring(string.lastIndexOf(":") + 1);
            if (string.startsWith("server:")) {
                if (name.endsWith(".class")) {
                    this.m_className = value;
                    continue;
                }
                this.setParameterValue(name, value, true);
                continue;
            }
            if (string.startsWith("module.")) {
                String role = string.substring(7, string.lastIndexOf(":"));
                ModuleConfiguration module = this.getModuleConfiguration(role);
                if (module == null) {
                    module = new ModuleConfiguration(new ArrayList<Parameter>(), role, null, null);
                    this.m_moduleConfigurations.add(module);
                }
                if (name.endsWith(".class")) {
                    module.setClassName(value);
                    continue;
                }
                module.setParameterValue(name, value, true);
                continue;
            }
            if (!string.startsWith("datastore.")) continue;
            String id = string.substring(10, string.lastIndexOf(":"));
            DatastoreConfiguration datastore = this.getDatastoreConfiguration(id);
            if (datastore == null) {
                datastore = new DatastoreConfiguration(new ArrayList<Parameter>(), id, null);
                this.m_datastoreConfigurations.add(datastore);
            }
            datastore.setParameterValue(name, value, true);
        }
    }

    public void serialize(OutputStream xmlStream) throws IOException {
        PrintStream out = new PrintStream(xmlStream);
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<server xmlns=\"" + ServerConfiguration.FCFG.uri + "\" class=\"" + this.m_className + "\">");
        this.serializeParameters(this.getParameters(), 2, out);
        for (ModuleConfiguration mc : this.getModuleConfigurations()) {
            out.println("  <module role=\"" + mc.getRole() + "\" class=\"" + mc.getClassName() + "\">");
            String comment = this.strip(mc.getComment());
            if (comment != null) {
                out.println("    <comment>" + comment + "</comment>");
            }
            this.serializeParameters(mc.getParameters(), 4, out);
            out.println("  </module>");
        }
        for (DatastoreConfiguration dc : this.getDatastoreConfigurations()) {
            out.println("  <datastore id=\"" + dc.getId() + "\">");
            String comment = this.strip(dc.getComment());
            if (comment != null) {
                out.println("    <comment>" + comment + "</comment>");
            }
            this.serializeParameters(dc.getParameters(), 4, out);
            out.println("  </datastore>");
        }
        out.println("</server>");
        out.close();
    }

    private void serializeParameters(List params, int indentBy, PrintStream out) {
        Iterator paramIter = params.iterator();
        while (paramIter.hasNext()) {
            out.println(this.getParamXMLString((Parameter)paramIter.next(), indentBy));
        }
    }

    private String spaces(int num) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            out.append(' ');
        }
        return out.toString();
    }

    private String getParamXMLString(Parameter p, int indentBy) {
        String comment;
        StringBuffer out = new StringBuffer();
        out.append(this.spaces(indentBy) + "<param name=\"" + p.getName() + "\" value=\"" + this.enc(p.getValue()) + "\"");
        if (p.getIsFilePath()) {
            out.append(" isFilePath=\"true\"");
        }
        if (p.getProfileValues() != null) {
            for (String profileName : p.getProfileValues().keySet()) {
                String profileVal = p.getProfileValues().get(profileName);
                out.append(" " + profileName + "value=\"" + this.enc(profileVal) + "\"");
            }
        }
        if ((comment = this.strip(p.getComment())) != null) {
            out.append(">\n" + this.spaces(indentBy + 2) + "<comment>" + this.enc(comment) + "</comment>\n" + this.spaces(indentBy) + "</param>");
        } else {
            out.append("/>");
        }
        return out.toString();
    }

    private String enc(String in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '\'') {
                out.append("&apos;");
                continue;
            }
            if (c == '\"') {
                out.append("&quot;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private String strip(String in) {
        if (in == null) {
            return null;
        }
        String out = ServerConfiguration.stripTrailing(ServerConfiguration.stripLeading(in));
        if (out.length() == 0) {
            return null;
        }
        return out;
    }

    private static String stripLeading(String in) {
        StringBuffer out = new StringBuffer();
        boolean foundNonWhitespace = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (foundNonWhitespace) {
                out.append(c);
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n') continue;
            foundNonWhitespace = true;
            out.append(c);
        }
        return out.toString();
    }

    private static String stripTrailing(String in) {
        StringBuffer out = new StringBuffer();
        boolean foundNonWhitespace = false;
        for (int i = in.length() - 1; i >= 0; --i) {
            char c = in.charAt(i);
            if (foundNonWhitespace) {
                out.insert(0, c);
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n') continue;
            foundNonWhitespace = true;
            out.insert(0, c);
        }
        return out.toString();
    }

    public String getClassName() {
        return this.m_className;
    }

    public List<ModuleConfiguration> getModuleConfigurations() {
        return this.m_moduleConfigurations;
    }

    public ModuleConfiguration getModuleConfiguration(String role) {
        for (int i = 0; i < this.m_moduleConfigurations.size(); ++i) {
            ModuleConfiguration config = this.m_moduleConfigurations.get(i);
            if (!config.getRole().equals(role)) continue;
            return config;
        }
        return null;
    }

    public List<DatastoreConfiguration> getDatastoreConfigurations() {
        return this.m_datastoreConfigurations;
    }

    public DatastoreConfiguration getDatastoreConfiguration(String id) {
        for (int i = 0; i < this.m_datastoreConfigurations.size(); ++i) {
            DatastoreConfiguration config = this.m_datastoreConfigurations.get(i);
            if (!config.getId().equals(id)) continue;
            return config;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            throw new IOException("One or two arguments expected.");
        }
        ServerConfiguration config = new ServerConfigurationParser(new FileInputStream(new File(args[0]))).parse();
        if (args.length == 2) {
            Properties props = new Properties();
            props.load(new FileInputStream(new File(args[1])));
            config.applyProperties(props);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        config.serialize(out);
        String content = new String(out.toByteArray(), "UTF-8");
        System.out.println(content);
    }
}

