/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.search;

import fedora.server.errors.InvalidOperatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operator {
    EQUALS("=", "eq"),
    CONTAINS("~", "has"),
    GREATER_THAN(">", "gt"),
    GREATER_OR_EQUAL(">=", "ge"),
    LESS_THAN("<", "lt"),
    LESS_OR_EQUAL("<=", "le");

    private final String symbol;
    private final String abbreviation;

    private Operator(String symbol, String abbreviation) {
        this.symbol = symbol;
        this.abbreviation = abbreviation;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static Operator fromAbbreviation(String abbreviation) throws InvalidOperatorException {
        for (Operator operator : Operator.values()) {
            if (!operator.abbreviation.equals(abbreviation)) continue;
            return operator;
        }
        throw new InvalidOperatorException("Operator, '" + abbreviation + "' does not match one of eq, has, gt, ge, lt, or le.");
    }

    public String toString() {
        return this.name() + "[" + this.symbol + ", " + this.abbreviation + "]";
    }
}

