/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.utilities;

import fedora.common.Constants;
import fedora.common.rdf.RDFName;
import fedora.server.errors.ObjectIntegrityException;
import fedora.server.errors.RepositoryConfigurationException;
import fedora.server.errors.StreamIOException;
import fedora.server.utilities.StreamUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DCFields
extends DefaultHandler
implements Constants {
    private final ArrayList<String> m_titles = new ArrayList();
    private final ArrayList<String> m_creators = new ArrayList();
    private final ArrayList<String> m_subjects = new ArrayList();
    private final ArrayList<String> m_descriptions = new ArrayList();
    private final ArrayList<String> m_publishers = new ArrayList();
    private final ArrayList<String> m_contributors = new ArrayList();
    private final ArrayList<String> m_dates = new ArrayList();
    private final ArrayList<String> m_types = new ArrayList();
    private final ArrayList<String> m_formats = new ArrayList();
    private final ArrayList<String> m_identifiers = new ArrayList();
    private final ArrayList<String> m_sources = new ArrayList();
    private final ArrayList<String> m_languages = new ArrayList();
    private final ArrayList<String> m_relations = new ArrayList();
    private final ArrayList<String> m_coverages = new ArrayList();
    private final ArrayList<String> m_rights = new ArrayList();
    private StringBuffer m_currentContent;

    public DCFields() {
    }

    public DCFields(InputStream in) throws RepositoryConfigurationException, ObjectIntegrityException, StreamIOException {
        SAXParser parser = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            parser = spf.newSAXParser();
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Error getting SAX parser for DC metadata: " + e.getClass().getName() + ": " + e.getMessage());
        }
        try {
            parser.parse(in, (DefaultHandler)this);
        }
        catch (SAXException saxe) {
            throw new ObjectIntegrityException("Parse error parsing DC XML Metadata: " + saxe.getMessage());
        }
        catch (IOException ioe) {
            throw new StreamIOException("Stream error parsing DC XML Metadata: " + ioe.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        this.m_currentContent = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.m_currentContent.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("title")) {
            this.titles().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("creator")) {
            this.creators().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("subject")) {
            this.subjects().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("description")) {
            this.descriptions().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("publisher")) {
            this.publishers().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("contributor")) {
            this.contributors().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("date")) {
            this.dates().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("type")) {
            this.types().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("format")) {
            this.formats().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("identifier")) {
            this.identifiers().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("source")) {
            this.sources().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("language")) {
            this.languages().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("relation")) {
            this.relations().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("coverage")) {
            this.coverages().add(this.m_currentContent.toString().trim());
        } else if (localName.equals("rights")) {
            this.rights().add(this.m_currentContent.toString().trim());
        }
    }

    public Map<RDFName, List<String>> getMap() {
        HashMap<RDFName, List<String>> map = new HashMap<RDFName, List<String>>();
        map.put(DCFields.DC.TITLE, this.m_titles);
        map.put(DCFields.DC.CREATOR, this.m_creators);
        map.put(DCFields.DC.SUBJECT, this.m_subjects);
        map.put(DCFields.DC.DESCRIPTION, this.m_descriptions);
        map.put(DCFields.DC.PUBLISHER, this.m_publishers);
        map.put(DCFields.DC.CONTRIBUTOR, this.m_contributors);
        map.put(DCFields.DC.DATE, this.m_dates);
        map.put(DCFields.DC.TYPE, this.m_types);
        map.put(DCFields.DC.FORMAT, this.m_formats);
        map.put(DCFields.DC.IDENTIFIER, this.m_identifiers);
        map.put(DCFields.DC.SOURCE, this.m_sources);
        map.put(DCFields.DC.LANGUAGE, this.m_languages);
        map.put(DCFields.DC.RELATION, this.m_relations);
        map.put(DCFields.DC.COVERAGE, this.m_coverages);
        map.put(DCFields.DC.RIGHTS, this.m_rights);
        return map;
    }

    public List<String> titles() {
        return this.m_titles;
    }

    public List<String> creators() {
        return this.m_creators;
    }

    public List<String> subjects() {
        return this.m_subjects;
    }

    public List<String> descriptions() {
        return this.m_descriptions;
    }

    public List<String> publishers() {
        return this.m_publishers;
    }

    public List<String> contributors() {
        return this.m_contributors;
    }

    public List<String> dates() {
        return this.m_dates;
    }

    public List<String> types() {
        return this.m_types;
    }

    public List<String> formats() {
        return this.m_formats;
    }

    public List<String> identifiers() {
        return this.m_identifiers;
    }

    public List<String> sources() {
        return this.m_sources;
    }

    public List<String> languages() {
        return this.m_languages;
    }

    public List<String> relations() {
        return this.m_relations;
    }

    public List<String> coverages() {
        return this.m_coverages;
    }

    public List<String> rights() {
        return this.m_rights;
    }

    public String getAsXML() {
        StringBuffer out = new StringBuffer();
        out.append("<" + DCFields.OAI_DC.prefix + ":dc" + " xmlns:" + DCFields.OAI_DC.prefix + "=\"" + DCFields.OAI_DC.uri + "\"" + " xmlns:" + DCFields.DC.prefix + "=\"" + DCFields.DC.uri + "\">\n");
        this.appendXML(this.titles(), "title", out);
        this.appendXML(this.creators(), "creator", out);
        this.appendXML(this.subjects(), "subject", out);
        this.appendXML(this.descriptions(), "description", out);
        this.appendXML(this.publishers(), "publisher", out);
        this.appendXML(this.contributors(), "contributor", out);
        this.appendXML(this.dates(), "date", out);
        this.appendXML(this.types(), "type", out);
        this.appendXML(this.formats(), "format", out);
        this.appendXML(this.identifiers(), "identifier", out);
        this.appendXML(this.sources(), "source", out);
        this.appendXML(this.languages(), "language", out);
        this.appendXML(this.relations(), "relation", out);
        this.appendXML(this.coverages(), "coverage", out);
        this.appendXML(this.rights(), "rights", out);
        out.append("</oai_dc:dc>\n");
        return out.toString();
    }

    private void appendXML(List<String> values, String name, StringBuffer out) {
        for (int i = 0; i < values.size(); ++i) {
            out.append("  <dc:" + name + ">");
            out.append(StreamUtility.enc(values.get(i)));
            out.append("</dc:" + name + ">\n");
        }
    }
}

