/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.utilities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class DateUtility {
    private static final Date ONE_BCE = new Date(-62167392000000L);
    private static final Date ONE_CE = new Date(-62135769600000L);

    public static Date convertStringToDate(String dateTime) {
        return DateUtility.parseDateAsUTC(dateTime);
    }

    public static String convertDateToString(Date date) {
        return DateUtility.convertDateToString(date, true);
    }

    public static String convertDateToString(Date date, boolean millis) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = millis ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (date.before(ONE_CE)) {
            StringBuilder sb = new StringBuilder(df.format(date));
            sb.insert(0, "-");
            return sb.toString();
        }
        return df.format(date);
    }

    public static String convertDateToXSDString(Date date) {
        StringBuilder lexicalForm;
        int len;
        if (date == null) {
            return null;
        }
        String dateTime = DateUtility.convertDateToString(date, true);
        if (dateTime.indexOf(46, (len = dateTime.length() - 1) - 4) != -1) {
            while (dateTime.charAt(len - 1) == '0') {
                --len;
            }
            if (dateTime.charAt(len - 1) == '.') {
                --len;
            }
            lexicalForm = new StringBuilder(dateTime.substring(0, len));
            lexicalForm.append('Z');
        } else {
            lexicalForm = new StringBuilder(dateTime);
        }
        if (date.before(ONE_CE)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            StringBuilder year = new StringBuilder(String.valueOf(Integer.parseInt(df.format(date)) - 1));
            while (year.length() < 4) {
                year.insert(0, '0');
            }
            lexicalForm.replace(0, lexicalForm.indexOf("-", 4), year.toString());
            if (date.before(ONE_BCE)) {
                lexicalForm.insert(0, "-");
            }
        }
        return lexicalForm.toString();
    }

    public static String convertDateToDateString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    public static String convertDateToTimeString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    public static Date parseDateAsUTC(String dateString) {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat();
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        int length = dateString.length();
        if (dateString.startsWith("-")) {
            --length;
        }
        if (dateString.endsWith("Z")) {
            if (length == 11) {
                formatter.applyPattern("yyyy-MM-dd'Z'");
            } else if (length == 20) {
                formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            } else if (length == 22) {
                formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            } else if (length == 23) {
                formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
            } else if (length == 24) {
                formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            }
        } else if (length == 10) {
            formatter.applyPattern("yyyy-MM-dd");
        } else if (length == 19) {
            formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss");
        } else if (length == 21) {
            formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss.S");
        } else if (length == 22) {
            formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SS");
        } else if (length == 23) {
            formatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
        } else if (dateString.endsWith("GMT") || dateString.endsWith("UTC")) {
            formatter.applyPattern("EEE, dd MMMM yyyyy HH:mm:ss z");
        }
        try {
            return formatter.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

