/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.utilities;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis.encoding.Base64;
import org.apache.log4j.Logger;

public abstract class StreamUtility {
    private static final Logger LOG = Logger.getLogger((String)StreamUtility.class.getName());

    public static String enc(String in) {
        String inStr = in;
        if (inStr == null) {
            inStr = "";
        }
        StringBuffer out = new StringBuffer();
        StreamUtility.enc(inStr, out);
        return out.toString();
    }

    public static void enc(String in, StringBuffer out) {
        for (int i = 0; i < in.length(); ++i) {
            StreamUtility.enc(in.charAt(i), out);
        }
    }

    public static void enc(char[] in, int start, int length, StringBuffer out) {
        for (int i = start; i < length + start; ++i) {
            StreamUtility.enc(in[i], out);
        }
    }

    public static void enc(char in, StringBuffer out) {
        if (in == '&') {
            out.append("&amp;");
        } else if (in == '<') {
            out.append("&lt;");
        } else if (in == '>') {
            out.append("&gt;");
        } else if (in == '\"') {
            out.append("&quot;");
        } else if (in == '\'') {
            out.append("&apos;");
        } else {
            out.append(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipeStream(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            int len;
            byte[] buf = new byte[bufSize];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                in.close();
                out.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to close stream", (Throwable)e);
            }
            throw throwable;
        }
        try {
            in.close();
            out.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to close stream", (Throwable)e);
        }
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decode((String)data);
    }

    public static String encodeBase64(byte[] data) {
        return Base64.encode((byte[])data);
    }

    public static String encodeBase64(InputStream is) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamUtility.pipeStream(is, os, 1024);
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Unable to encode stream", (Throwable)ioe);
        }
        return Base64.encode((byte[])os.toByteArray());
    }
}

