/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.utilities;

import java.util.StringTokenizer;

public class StringUtility {
    public static String prettyPrint(String in, int lineLength, String delim) {
        StringBuffer sb = new StringBuffer();
        if (delim == null) {
            delim = " ";
        }
        StringTokenizer st = new StringTokenizer(in, delim);
        int charCount = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if ((charCount += s.length()) < lineLength) {
                sb.append(s + " ");
                ++charCount;
                continue;
            }
            sb.append("\n");
            sb.append(s + " ");
            charCount = s.length() + 1;
        }
        return sb.toString();
    }

    public static String splitAndIndent(String str, int indent, int numChars) {
        String s;
        StringBuffer sb = new StringBuffer();
        StringBuffer ib = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            ib.append(" ");
        }
        String indentStr = ib.toString();
        int offset = 0;
        for (int totalLength = str.length(); totalLength > numChars; totalLength -= numChars) {
            s = str.substring(offset, offset + numChars);
            sb.append(indentStr);
            sb.append(s);
            sb.append("\n");
            offset += numChars;
        }
        s = str.substring(offset);
        sb.append(indentStr);
        sb.append(s);
        sb.append("\n");
        return sb.toString();
    }

    public static String byteArraytoHexString(byte[] array) {
        String hexByte = "0123456789abcdef";
        StringBuffer buf = new StringBuffer();
        for (byte val : array) {
            int v1 = val >>> 4 & 0xF;
            int v2 = val & 0xF;
            buf.append("0123456789abcdef".substring(v1, v1 + 1)).append("0123456789abcdef".substring(v2, v2 + 1));
        }
        return buf.toString();
    }

    public static byte[] hexStringtoByteArray(String str) {
        if ((str.length() & 1) != 0) {
            throw new NumberFormatException();
        }
        byte[] ret = new byte[str.length() / 2];
        for (int i = 0; i < str.length() / 2; ++i) {
            ret[i] = (byte)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
        }
        return ret;
    }

    public static void main(String[] args) {
        byte[] result;
        new StringUtility();
        String pid = "demo:1";
        String in = "org.apache.axis.AxisFault: The digital object \"" + pid + "\" is used by one or more other objects " + "in the repository. All related objects must be removed " + "before this object may be deleted. Use the search " + "interface with the query \"bDef~" + pid + "\" to obtain a list of dependent objects.";
        System.out.println("123456789+123456789+123456789+123456789+123456789+123456789+123456789+123456789+");
        System.out.println(StringUtility.prettyPrint(in, 70, null));
        byte[] test = new byte[]{4, 90, -105, -68, -16, -126, -18, -47, 99};
        String testStr = StringUtility.byteArraytoHexString(test);
        System.out.println(testStr);
        for (byte element : result = StringUtility.hexStringtoByteArray(testStr)) {
            System.out.println(element);
        }
    }
}

