/*
 * Decompiled with CFR 0.152.
 */
package fedora.swing.jtable;

import fedora.swing.jtable.DefaultSortTableModel;
import fedora.swing.jtable.SortHeaderRenderer;
import fedora.swing.jtable.SortTableModel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class JSortTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;

    public JSortTable() {
        this(new DefaultSortTableModel());
    }

    public JSortTable(int rows, int cols) {
        this(new DefaultSortTableModel(rows, cols));
    }

    public JSortTable(Object[][] data, Object[] names) {
        this(new DefaultSortTableModel(data, names));
    }

    public JSortTable(Vector data, Vector names) {
        this(new DefaultSortTableModel(data, names));
    }

    public JSortTable(SortTableModel model) {
        super(model);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel model, TableColumnModel colModel) {
        super(model, colModel);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel model, TableColumnModel colModel, ListSelectionModel selModel) {
        super(model, colModel, selModel);
        this.initSortHeader();
    }

    protected void initSortHeader() {
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new SortHeaderRenderer());
        header.addMouseListener(this);
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public void mouseReleased(MouseEvent event) {
        TableColumnModel colModel = this.getColumnModel();
        int index = colModel.getColumnIndexAtX(event.getX());
        int modelIndex = colModel.getColumn(index).getModelIndex();
        SortTableModel model = (SortTableModel)this.getModel();
        if (model.isSortable(modelIndex)) {
            if (this.sortedColumnIndex == index) {
                this.sortedColumnAscending = !this.sortedColumnAscending;
            }
            this.sortedColumnIndex = index;
            model.sortColumn(modelIndex, this.sortedColumnAscending);
        }
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }
}

