/*
 * Decompiled with CFR 0.152.
 */
package fedora.utilities;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final int BUFFER = 8192;

    public static boolean copy(InputStream source, OutputStream destination) {
        byte[] data = new byte[8192];
        BufferedOutputStream dest = new BufferedOutputStream(destination, 8192);
        try {
            int count;
            while ((count = source.read(data, 0, 8192)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean copy(File source, File destination) {
        boolean result = true;
        if (source.isDirectory()) {
            File[] children;
            result = destination.exists() ? result && destination.isDirectory() : result && destination.mkdirs();
            for (File element : children = source.listFiles()) {
                result = result && FileUtils.copy(new File(source, element.getName()), new File(destination, element.getName()));
            }
            return result;
        }
        try {
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(destination);
            result = result && FileUtils.copy(in, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return result;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File createTempDir(String prefix, File directory) throws IOException {
        File tempFile = File.createTempFile(prefix, "", directory);
        if (!tempFile.delete()) {
            throw new IOException();
        }
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile;
    }

    public static boolean delete(File file) {
        boolean result = true;
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] children;
                for (File child : children = file.listFiles()) {
                    result = result && FileUtils.delete(child);
                }
            }
            result = result && file.delete();
        }
        return result;
    }

    public static boolean delete(String file) {
        return FileUtils.delete(new File(file));
    }

    public static boolean move(File source, File destination) {
        if (source == null || destination == null) {
            return false;
        }
        if (source.renameTo(destination)) {
            return true;
        }
        return FileUtils.copy(source, destination) && FileUtils.delete(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File f) throws IOException {
        Properties properties;
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(f);
        try {
            props.load(in);
            properties = props;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                in.close();
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadMap(File f) throws IOException {
        HashMap<String, String> hashMap;
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(f);
        try {
            props.load(in);
            HashMap<String, String> map = new HashMap<String, String>();
            Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
            hashMap = map;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                in.close();
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return hashMap;
    }

    public static FileFilter getPrefixFileFilter(String prefix) {
        return new PrefixFileFilter(prefix);
    }

    public static FileFilter getSuffixFileFilter(String suffix) {
        return new SuffixFileFilter(suffix);
    }

    private static class SuffixFileFilter
    implements FileFilter {
        private final String filenameSuffix;

        SuffixFileFilter(String filenameSuffix) {
            this.filenameSuffix = filenameSuffix;
        }

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(this.filenameSuffix);
        }
    }

    private static class PrefixFileFilter
    implements FileFilter {
        private final String filenamePrefix;

        PrefixFileFilter(String filenamePrefix) {
            this.filenamePrefix = filenamePrefix;
        }

        public boolean accept(File file) {
            String filename = file.getName();
            return filename.startsWith(this.filenamePrefix);
        }
    }
}

