/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.List;
import org.jppf.client.ClientConnectionHandler;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;

public abstract class AbstractClientConnectionHandler
implements ClientConnectionHandler {
    protected SocketWrapper socketClient = null;
    protected SocketInitializer socketInitializer = this.createSocketInitializer();
    protected String host = null;
    protected int port = -1;
    protected JPPFClientConnection owner = null;
    protected String name = null;
    protected JPPFClientConnectionStatus status = JPPFClientConnectionStatus.DISCONNECTED;
    protected List<ClientConnectionStatusListener> listeners = new ArrayList<ClientConnectionStatusListener>();

    protected AbstractClientConnectionHandler(JPPFClientConnection owner) {
        this.owner = owner;
        if (owner != null) {
            this.name = owner.getName();
        }
    }

    public synchronized JPPFClientConnectionStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatus(JPPFClientConnectionStatus status) {
        this.status = status;
        this.fireStatusChanged();
    }

    public void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.add(listener);
    }

    public void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract SocketInitializer createSocketInitializer();

    protected synchronized void fireStatusChanged() {
        ClientConnectionStatusListener[] array;
        ClientConnectionStatusEvent event = new ClientConnectionStatusEvent(this);
        ClientConnectionStatusListener[] clientConnectionStatusListenerArray = array = this.listeners.toArray(new ClientConnectionStatusListener[0]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ClientConnectionStatusListener listener = clientConnectionStatusListenerArray[n2];
            listener.statusChanged(event);
            ++n2;
        }
    }

    public SocketWrapper getSocketClient() {
        return this.socketClient;
    }
}

