/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.JPPFException;
import org.jppf.client.ClassServerDelegate;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.TaskServerConnectionHandler;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.data.transform.JPPFDataTransform;
import org.jppf.data.transform.JPPFDataTransformFactory;
import org.jppf.security.JPPFCredentials;
import org.jppf.security.JPPFSecurityContext;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFDistributedJob;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.MultipleBuffersInputStream;
import org.jppf.utils.MultipleBuffersOutputStream;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.Pair;
import org.jppf.utils.SerializationHelper;
import org.jppf.utils.TraversalList;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJPPFClientConnection
implements JPPFClientConnection {
    private static Log log = LogFactory.getLog(AbstractJPPFClientConnection.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static String SERIALIZATION_HELPER_IMPL = "org.jppf.utils.SerializationHelperImpl";
    protected TaskServerConnectionHandler taskServerConnection = null;
    protected ClassServerDelegate delegate = null;
    protected String appUuid = null;
    protected String host = null;
    protected int port = -1;
    protected int classServerPort = -1;
    protected JPPFSecurityContext credentials = null;
    protected int totalTaskCount = 0;
    protected String name = null;
    protected int priority = 0;
    protected JPPFClientConnectionStatus status = JPPFClientConnectionStatus.CONNECTING;
    protected List<ClientConnectionStatusListener> listeners = new ArrayList<ClientConnectionStatusListener>();
    protected JPPFJob job = null;
    protected boolean isShutdown = false;
    private String connectionId = new JPPFUuid().toString();

    protected AbstractJPPFClientConnection() {
    }

    public AbstractJPPFClientConnection(String uuid, String name, String host, int driverPort, int classServerPort, int priority) {
        this.configure(uuid, name, host, driverPort, classServerPort, priority);
    }

    protected void configure(String uuid, String name, String host, int driverPort, int classServerPort, int priority) {
        this.appUuid = uuid;
        this.host = NetworkUtils.getHostName((String)host);
        this.port = driverPort;
        this.priority = priority;
        this.classServerPort = classServerPort;
        this.name = name;
        this.taskServerConnection = new TaskServerConnectionHandler(this, this.host, this.port);
    }

    @Override
    public abstract void init();

    public void initCredentials() throws Exception {
        StringBuilder sb = new StringBuilder("Client:");
        sb.append(VersionUtils.getLocalIpAddress()).append(":");
        TypedProperties props = JPPFConfiguration.getProperties();
        sb.append(props.getInt("class.server.port", 11111)).append(":");
        sb.append(this.port).append(":");
        this.credentials = new JPPFSecurityContext(this.appUuid, sb.toString(), new JPPFCredentials());
    }

    public void sendTasks(JPPFJob job) throws Exception {
        try {
            JPPFTaskBundle bundle = new JPPFTaskBundle();
            this.sendTasks(bundle, job);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void sendTasks(JPPFTaskBundle header, JPPFJob job) throws Exception {
        ObjectSerializer ser = this.makeHelper().getSerializer();
        int count = job.getTasks().size();
        if (debugEnabled) {
            log.debug((Object)("[client: " + this.name + "] sending job '" + job.getId() + "' with " + count + " tasks"));
        }
        TraversalList uuidPath = new TraversalList();
        uuidPath.add((Object)this.appUuid);
        header.setUuidPath(uuidPath);
        header.setTaskCount(count);
        header.setParameter((Object)BundleParameter.JOB_ID, (Object)job.getId());
        header.setParameter((Object)BundleParameter.JOB_UUID, (Object)job.getJobUuid());
        header.setJobSLA(job.getJobSLA());
        header.setParameter((Object)BundleParameter.JOB_METADATA, (Object)job.getJobMetadata());
        SocketWrapper socketClient = this.taskServerConnection.getSocketClient();
        this.sendData(socketClient, header, ser);
        this.sendData(socketClient, job.getDataProvider(), ser);
        for (JPPFTask task : job.getTasks()) {
            this.sendData(socketClient, task, ser);
        }
        socketClient.flush();
    }

    private void sendData(SocketWrapper socketWrapper, Object o, ObjectSerializer ser) throws Exception {
        List list = null;
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        MultipleBuffersOutputStream mbos = new MultipleBuffersOutputStream();
        ser.serialize(o, (OutputStream)mbos);
        int size = mbos.size();
        if (transform != null) {
            MultipleBuffersInputStream mbis = new MultipleBuffersInputStream(mbos.toBufferList());
            mbos = new MultipleBuffersOutputStream();
            transform.wrap((InputStream)mbis, (OutputStream)mbos);
            list = mbos.toBufferList();
            size = mbos.size();
        } else {
            list = mbos.toBufferList();
        }
        socketWrapper.writeInt(size);
        for (JPPFBuffer buf : list) {
            socketWrapper.write(buf.buffer, 0, buf.length);
        }
    }

    public Pair<List<JPPFTask>, Integer> receiveResults() throws Exception {
        try {
            SocketWrapper socketClient = this.taskServerConnection.getSocketClient();
            ObjectSerializer ser = this.makeHelper().getSerializer();
            JPPFTaskBundle bundle = (JPPFTaskBundle)this.unwrappedData(socketClient.receiveBytes(0), ser);
            int count = bundle.getTaskCount();
            ArrayList<JPPFTask> taskList = new ArrayList<JPPFTask>();
            int i = 0;
            while (i < count) {
                taskList.add((JPPFTask)this.unwrappedData(socketClient.receiveBytes(0), ser));
                ++i;
            }
            int startIndex = taskList.isEmpty() ? -1 : ((JPPFTask)taskList.get(0)).getPosition();
            Throwable t = (Throwable)bundle.getParameter((Object)BundleParameter.NODE_EXCEPTION_PARAM);
            if (t != null) {
                Exception e = t instanceof Exception ? (Exception)t : new JPPFException(t);
                for (JPPFTask task : taskList) {
                    task.setException(e);
                }
            }
            Pair p = new Pair(taskList, (Object)startIndex);
            return p;
        }
        catch (AsynchronousCloseException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private Object unwrappedData(JPPFBuffer buffer, ObjectSerializer ser) throws Exception {
        byte[] data = buffer.getBuffer();
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        if (transform != null) {
            data = JPPFDataTransformFactory.transform((JPPFDataTransform)transform, (boolean)false, (byte[])data);
        }
        return ser.deserialize(data);
    }

    protected SerializationHelper makeHelper() throws Exception {
        return this.makeHelper(null);
    }

    protected SerializationHelper makeHelper(ClassLoader cl) throws Exception {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        String helperClassName = this.getSerializationHelperClassName();
        Class<?> clazz = null;
        if (cl != null) {
            try {
                clazz = cl.loadClass(helperClassName);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (clazz == null) {
            cl = this.getClass().getClassLoader();
            clazz = cl.loadClass(helperClassName);
        }
        SerializationHelper helper = (SerializationHelper)clazz.newInstance();
        return helper;
    }

    protected String getSerializationHelperClassName() {
        return JPPFConfiguration.getProperties().getString("jppf.serialization.helper.class", SERIALIZATION_HELPER_IMPL);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public synchronized JPPFClientConnectionStatus getStatus() {
        return this.status;
    }

    @Override
    public synchronized void setStatus(JPPFClientConnectionStatus status) {
        this.status = status;
        this.fireStatusChanged();
    }

    @Override
    public synchronized void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireStatusChanged() {
        ClientConnectionStatusListener[] array;
        ClientConnectionStatusEvent event = new ClientConnectionStatusEvent(this);
        ClientConnectionStatusListener[] clientConnectionStatusListenerArray = array = this.listeners.toArray(new ClientConnectionStatusListener[0]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ClientConnectionStatusListener listener = clientConnectionStatusListenerArray[n2];
            listener.statusChanged(event);
            ++n2;
        }
    }

    @Override
    public abstract List<JPPFJob> close();

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + " : " + (Object)((Object)this.status);
    }

    protected abstract SocketInitializer createSocketInitializer();

    public JPPFDistributedJob getCurrentJob() {
        return this.job;
    }

    public void setCurrentJob(JPPFJob currentExecution) {
        this.job = currentExecution;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public TaskServerConnectionHandler getTaskServerConnection() {
        return this.taskServerConnection;
    }

    public void delegateStatusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnectionStatus s1 = event.getClientConnectionStatusHandler().getStatus();
        JPPFClientConnectionStatus s2 = this.taskServerConnection.getStatus();
        this.processStatusChanged(s1, s2);
    }

    public void taskServerConnectionStatusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnectionStatus s1 = event.getClientConnectionStatusHandler().getStatus();
        JPPFClientConnectionStatus s2 = this.delegate.getStatus();
        this.processStatusChanged(s2, s1);
    }

    protected void processStatusChanged(JPPFClientConnectionStatus delegateStatus, JPPFClientConnectionStatus taskConnectionStatus) {
        if (JPPFClientConnectionStatus.FAILED.equals((Object)delegateStatus)) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
        } else if (JPPFClientConnectionStatus.ACTIVE.equals((Object)delegateStatus)) {
            if (JPPFClientConnectionStatus.ACTIVE.equals((Object)taskConnectionStatus) && !JPPFClientConnectionStatus.ACTIVE.equals((Object)this.getStatus())) {
                this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            } else if (!taskConnectionStatus.equals((Object)this.getStatus())) {
                this.setStatus(taskConnectionStatus);
            }
        } else if (JPPFClientConnectionStatus.ACTIVE.equals((Object)taskConnectionStatus)) {
            this.setStatus(delegateStatus);
        } else {
            int n = delegateStatus.compareTo(taskConnectionStatus);
            if (n < 0 && !delegateStatus.equals((Object)this.getStatus())) {
                this.setStatus(delegateStatus);
            } else if (!taskConnectionStatus.equals((Object)this.getStatus())) {
                this.setStatus(taskConnectionStatus);
            }
        }
    }
}

