/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.NotSerializableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFJob;

public class AsynchronousResultProcessor
implements Runnable {
    private static Log log = LogFactory.getLog(AsynchronousResultProcessor.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final JPPFClientConnectionImpl connection;
    private JPPFJob job = null;

    public AsynchronousResultProcessor(JPPFClientConnectionImpl connection, JPPFJob job) {
        this.connection = connection;
        this.job = job;
    }

    public void run() {
        boolean error = false;
        try {
            try {
                if (!this.job.isBlocking()) {
                    this.connection.getLock().lock();
                }
                this.connection.job = this.job;
                boolean count = false;
                count = false;
                boolean completed = false;
                try {
                    JPPFClient.getLoadBalancer().execute(this.job, this.connection);
                }
                catch (NotSerializableException e) {
                    throw e;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)("[" + this.connection.getName() + "] " + e.getMessage()), (Throwable)e);
                    this.connection.getTaskServerConnection().init();
                }
            }
            catch (Exception e) {
                error = true;
                log.error((Object)("[" + this.connection.getName() + "] " + e.getMessage()), (Throwable)e);
                if (!this.job.isBlocking()) {
                    this.connection.getLock().unlock();
                }
                if (!error) {
                    this.connection.job = null;
                }
            }
        }
        finally {
            if (!this.job.isBlocking()) {
                this.connection.getLock().unlock();
            }
            if (!error) {
                this.connection.job = null;
            }
        }
    }

    public JPPFJob getJob() {
        return this.job;
    }
}

