/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.JPPFException;
import org.jppf.client.AbstractGenericClient;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFJob;
import org.jppf.client.JPPFResultCollector;
import org.jppf.client.event.ClientListener;
import org.jppf.client.event.TaskResultListener;
import org.jppf.client.loadbalancer.LoadBalancer;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.server.JPPFStats;
import org.jppf.server.protocol.JPPFJobSLA;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFClient
extends AbstractGenericClient {
    private static Log log = LogFactory.getLog(JPPFClient.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static LoadBalancer loadBalancer = new LoadBalancer();
    public static final boolean LOCAL_EXEC_ENABLED = JPPFConfiguration.getProperties().getBoolean("jppf.local.execution.enabled", true);

    public JPPFClient() {
        super(JPPFConfiguration.getProperties());
    }

    public JPPFClient(ClientListener ... listeners) {
        this();
        ClientListener[] clientListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ClientListener listener = clientListenerArray[n2];
            this.addClientListener(listener);
            ++n2;
        }
    }

    public JPPFClient(String uuid) {
        super((Object)uuid);
    }

    public JPPFClient(String uuid, ClientListener ... listeners) {
        this(uuid);
        ClientListener[] clientListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ClientListener listener = clientListenerArray[n2];
            this.addClientListener(listener);
            ++n2;
        }
    }

    @Override
    protected void initConfig(Object configuration) {
        this.config = (TypedProperties)configuration;
    }

    @Override
    protected AbstractJPPFClientConnection createConnection(String uuid, String name, JPPFConnectionInformation info) {
        return new JPPFClientConnectionImpl(uuid, name, info);
    }

    @Override
    public List<JPPFTask> submit(List<JPPFTask> taskList, DataProvider dataProvider, ExecutionPolicy policy, int priority) throws Exception {
        JPPFJobSLA sla = new JPPFJobSLA(policy, priority);
        JPPFJob job = new JPPFJob(dataProvider, sla, true, null);
        for (JPPFTask task : taskList) {
            job.addTask(task, new Object[0]);
        }
        return this.submit(job);
    }

    @Override
    public List<JPPFTask> submit(JPPFJob job) throws Exception {
        JPPFClientConnectionImpl c = (JPPFClientConnectionImpl)this.getClientConnection(true);
        if (job.isBlocking()) {
            if (c != null) {
                JPPFResultCollector collector = new JPPFResultCollector(job.getTasks().size());
                job.setResultListener(collector);
                c.submit(job);
                return collector.waitForResults();
            }
            if (LOCAL_EXEC_ENABLED) {
                JPPFResultCollector collector = new JPPFResultCollector(job.getTasks().size());
                job.setResultListener(collector);
                JPPFClient.getLoadBalancer().execute(job, null);
                return collector.waitForResults();
            }
        } else {
            if (c != null) {
                c.submit(job);
                return null;
            }
            if (LOCAL_EXEC_ENABLED) {
                JPPFClient.getLoadBalancer().execute(job, null);
                return null;
            }
        }
        throw new JPPFException("Cannot execute: no driver connection available and local execution is disabled");
    }

    @Override
    public void submitNonBlocking(List<JPPFTask> taskList, DataProvider dataProvider, TaskResultListener listener, ExecutionPolicy policy, int priority) throws Exception {
        JPPFJobSLA sla = new JPPFJobSLA(policy, priority);
        JPPFJob job = new JPPFJob(dataProvider, sla, false, listener);
        for (JPPFTask task : taskList) {
            job.addTask(task, new Object[0]);
        }
        this.submit(job);
    }

    public JPPFStats requestStatistics() throws Exception {
        JPPFClientConnectionImpl conn = (JPPFClientConnectionImpl)this.getClientConnection(true);
        return conn == null ? null : conn.getJmxConnection().statistics();
    }

    @Override
    public void close() {
        super.close();
        if (loadBalancer != null) {
            loadBalancer.stop();
        }
    }

    public static LoadBalancer getLoadBalancer() {
        return loadBalancer;
    }
}

