/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.JPPFError;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.AsynchronousResultProcessor;
import org.jppf.client.ClassServerDelegateImpl;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.TypedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFClientConnectionImpl
extends AbstractJPPFClientConnection {
    private static Log log = LogFactory.getLog(JPPFClientConnectionImpl.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private ReentrantLock lock = new ReentrantLock();
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>());
    private JMXDriverConnectionWrapper jmxConnection = null;
    private int jmxPort = -1;
    private TypedProperties props = null;

    public JPPFClientConnectionImpl(String uuid, String name, JPPFConnectionInformation info) {
        this.classServerPort = info.classServerPorts[0];
        this.jmxPort = info.managementPort;
        this.configure(uuid, name, info.host, info.applicationServerPorts[0], this.classServerPort, 0);
        this.initializeJmxConnection();
    }

    @Override
    public void init() {
        try {
            this.delegate = new ClassServerDelegateImpl(this, this.appUuid, this.host, this.classServerPort);
            this.delegate.addClientConnectionStatusListener(new ClientConnectionStatusListener(){

                public void statusChanged(ClientConnectionStatusEvent event) {
                    JPPFClientConnectionImpl.this.delegateStatusChanged(event);
                }
            });
            this.taskServerConnection.addClientConnectionStatusListener(new ClientConnectionStatusListener(){

                public void statusChanged(ClientConnectionStatusEvent event) {
                    JPPFClientConnectionImpl.this.taskServerConnectionStatusChanged(event);
                }
            });
            this.delegate.init();
            this.initCredentials();
            if (!this.delegate.isClosed()) {
                Thread t = new Thread(this.delegate);
                t.setName("[" + this.delegate.getName() + " : class delegate]");
                t.start();
                this.taskServerConnection.init();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.setStatus(JPPFClientConnectionStatus.FAILED);
        }
        catch (JPPFError e) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
            throw e;
        }
    }

    public void initializeJmxConnection() {
        String mHost = null;
        int port = -1;
        if (this.props != null) {
            String prefix = String.valueOf(this.name) + ".";
            mHost = this.props.getString(String.valueOf(prefix) + "jppf.management.host", "localhost");
            port = this.props.getInt(String.valueOf(prefix) + "jppf.management.port", 11198);
        } else {
            if (this.jmxPort < 0) {
                return;
            }
            mHost = this.host;
            port = this.jmxPort;
        }
        mHost = NetworkUtils.getHostName((String)mHost);
        this.jmxConnection = new JMXDriverConnectionWrapper(mHost, port);
        this.jmxConnection.connect();
    }

    @Override
    public void submit(JPPFJob job) throws Exception {
        AsynchronousResultProcessor proc = new AsynchronousResultProcessor(this, job);
        this.executor.submit(proc);
        if (debugEnabled) {
            log.debug((Object)("[" + this.name + "] submitted " + job.getTasks().size() + " tasks"));
        }
    }

    @Override
    public List<JPPFJob> close() {
        if (!this.isShutdown) {
            this.isShutdown = true;
            try {
                if (this.taskServerConnection != null) {
                    this.taskServerConnection.close();
                }
                if (this.delegate != null) {
                    this.delegate.close();
                }
                if (this.jmxConnection != null) {
                    this.jmxConnection.close();
                }
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug((Object)("[" + this.name + "] " + e.getMessage()), (Throwable)e);
                }
                log.error((Object)("[" + this.name + "] " + e.getMessage()));
            }
            ArrayList<Runnable> pending = new ArrayList<Runnable>();
            pending.addAll(this.executor.shutdownNow());
            ArrayList<JPPFJob> result = new ArrayList<JPPFJob>();
            if (this.job != null) {
                result.add(this.job);
            }
            while (!pending.isEmpty()) {
                AsynchronousResultProcessor proc = (AsynchronousResultProcessor)pending.remove(0);
                result.add(proc.getJob());
            }
            return result;
        }
        return null;
    }

    @Override
    protected SocketInitializer createSocketInitializer() {
        return new SocketInitializerImpl();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public JMXDriverConnectionWrapper getJmxConnection() {
        return this.jmxConnection;
    }

    @Override
    public String toString() {
        return String.valueOf(this.name) + "( " + this.host + ":" + this.jmxPort + ") : " + (Object)((Object)this.status);
    }
}

