/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.JPPFException;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFJob;
import org.jppf.client.concurrent.FutureResultCollector;
import org.jppf.client.concurrent.FutureResultCollectorEvent;
import org.jppf.client.concurrent.FutureResultCollectorListener;
import org.jppf.client.concurrent.JPPFTaskFuture;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.DateTimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFExecutorService
implements ExecutorService,
FutureResultCollectorListener {
    private static Log log = LogFactory.getLog(JPPFExecutorService.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private JPPFClient client = null;
    private Map<String, JPPFJob> jobMap = new Hashtable<String, JPPFJob>();
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private AtomicBoolean terminated = new AtomicBoolean(false);
    private static AtomicLong jobCount = new AtomicLong(0L);

    public JPPFExecutorService(JPPFClient client) {
        this.client = client;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(tasks, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shuttingDown.get()) {
            throw new RejectedExecutionException("Shutdown has already been requested");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        long start = System.currentTimeMillis();
        long millis = DateTimeUtils.toMillis((long)timeout, (TimeUnit)unit);
        if (debugEnabled) {
            log.debug((Object)("timeout in millis: " + millis));
        }
        JPPFJob job = this.createJob();
        FutureResultCollector collector = (FutureResultCollector)job.getResultListener();
        ArrayList<Future<T>> futureList = new ArrayList<Future<T>>(tasks.size());
        try {
            int position = 0;
            for (Callable<T> task : tasks) {
                if (task == null) {
                    throw new NullPointerException("a task cannot be null");
                }
                JPPFTask jppfTask = this.addToJob(job, task);
                futureList.add(new JPPFTaskFuture(collector, position++));
            }
            collector.setTaskCount(job.getTasks().size());
            this.submitJob(job);
            long elapsed = System.currentTimeMillis() - start;
            if (millis == 0L || elapsed < millis) {
                collector.waitForResults(millis == 0L ? 0L : millis - elapsed);
            }
            elapsed = System.currentTimeMillis() - start;
            if (debugEnabled) {
                log.debug((Object)("elapsed=" + elapsed));
            }
            this.handleFutureList(futureList);
        }
        catch (InterruptedException e) {
            this.handleFutureList(futureList);
            throw e;
        }
        catch (Exception e) {
            throw new RejectedExecutionException(e);
        }
        return futureList;
    }

    private <T> void handleFutureList(List<Future<T>> futureList) {
        for (Future<T> f : futureList) {
            if (f.isDone()) continue;
            JPPFTaskFuture future = (JPPFTaskFuture)f;
            future.setDone();
            future.setCancelled();
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.invokeAny(tasks, 0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        List<Future<T>> futureList = this.invokeAll(tasks, timeout, unit);
        for (Future<T> f : futureList) {
            if (!f.isDone() || f.isCancelled()) continue;
            return f.get();
        }
        return null;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this.shuttingDown.get()) {
            throw new RejectedExecutionException("Shutdown has already been requested");
        }
        JPPFJob job = this.createJob();
        JPPFTaskFuture future = null;
        try {
            JPPFTask jppfTask = this.addToJob(job, task);
            FutureResultCollector collector = (FutureResultCollector)job.getResultListener();
            future = new JPPFTaskFuture(collector, jppfTask.getPosition());
            this.submitJob(job);
        }
        catch (Exception e) {
            throw new RejectedExecutionException(e);
        }
        return future;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(new RunnableWrapper<Object>(task, null));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(new RunnableWrapper<T>(task, result));
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long millis = DateTimeUtils.toMillis((long)timeout, (TimeUnit)unit);
        this.waitForTerminated(millis);
        return this.terminated.get();
    }

    @Override
    public boolean isShutdown() {
        return this.shuttingDown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTerminated() {
        this.terminated.set(true);
        JPPFExecutorService jPPFExecutorService = this;
        synchronized (jPPFExecutorService) {
            this.notifyAll();
        }
    }

    @Override
    public void shutdown() {
        this.shuttingDown.set(true);
        this.terminated.compareAndSet(false, this.jobMap.isEmpty());
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shuttingDown.set(true);
        this.terminated.compareAndSet(false, this.jobMap.isEmpty());
        this.waitForTerminated(0L);
        return null;
    }

    private JPPFJob createJob() {
        JPPFJob job = new JPPFJob();
        job.setId(String.valueOf(this.getClass().getSimpleName()) + " job " + jobCount.incrementAndGet());
        FutureResultCollector collector = new FutureResultCollector(0, job.getJobUuid());
        job.setResultListener(collector);
        job.setBlocking(false);
        collector.addListener(this);
        return job;
    }

    private JPPFTask addToJob(JPPFJob job, Object object) throws JPPFException {
        return job.addTask(object, new Object[0]);
    }

    private void submitJob(JPPFJob job) throws Exception {
        this.client.submit(job);
        this.jobMap.put(job.getJobUuid(), job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTerminated(long timeout) {
        long elapsed = 0L;
        long start = System.currentTimeMillis();
        while (!(this.terminated.get() || timeout != 0L && elapsed >= timeout)) {
            JPPFExecutorService jPPFExecutorService = this;
            synchronized (jPPFExecutorService) {
                try {
                    this.wait(timeout == 0L ? 0L : timeout - elapsed);
                }
                catch (InterruptedException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                elapsed = System.currentTimeMillis() - start;
            }
        }
    }

    @Override
    public void resultsComplete(FutureResultCollectorEvent event) {
        String jobUuid = event.getCollector().getJobUuid();
        this.jobMap.remove(jobUuid);
        if (this.shuttingDown.get() && this.jobMap.isEmpty()) {
            this.setTerminated();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RunnableWrapper<V>
    implements Callable<V>,
    Serializable {
        private Runnable runnable = null;
        private V result = null;

        public RunnableWrapper(Runnable runnable, V result) {
            this.runnable = runnable;
            this.result = result;
        }

        @Override
        public V call() {
            this.runnable.run();
            return this.result;
        }
    }
}

