/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jppf.client.concurrent.AbstractJPPFFuture;
import org.jppf.client.concurrent.FutureResultCollector;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.DateTimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JPPFTaskFuture<V>
extends AbstractJPPFFuture<V> {
    private FutureResultCollector collector = null;
    private int position = -1;
    private String jobId = null;
    private JMXDriverConnectionWrapper jmx = null;

    public JPPFTaskFuture(FutureResultCollector collector, int position) {
        this(collector, position, null, null);
    }

    public JPPFTaskFuture(FutureResultCollector collector, int position, String jobId, JMXDriverConnectionWrapper jmx) {
        this.collector = collector;
        this.position = position;
        this.jobId = jobId;
        this.jmx = jmx;
    }

    @Override
    public boolean isDone() {
        this.done.compareAndSet(false, this.collector.isTaskReceived(this.position));
        return this.done.get();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.isDone()) {
            JPPFTask task = this.collector.getTask(this.position);
            return (V)(task == null ? null : task.getResult());
        }
        return (V)this.collector.waitForTask(this.position).getResult();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isDone()) {
            JPPFTask task = this.collector.getTask(this.position);
            return (V)(task == null ? null : task.getResult());
        }
        long millis = DateTimeUtils.toMillis((long)timeout, (TimeUnit)unit);
        return (V)this.collector.waitForTask(this.position, millis).getResult();
    }

    void setDone() {
        this.done.set(true);
    }

    void setCancelled() {
        this.cancelled.set(true);
    }
}

