/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceProvider;
import org.jppf.client.AbstractClientConnectionHandler;
import org.jppf.client.ClassServerDelegate;
import org.jppf.client.JPPFClientConnection;
import org.jppf.comm.socket.SocketClient;
import org.jppf.data.transform.JPPFDataTransform;
import org.jppf.data.transform.JPPFDataTransformFactory;
import org.jppf.utils.JPPFBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassServerDelegate
extends AbstractClientConnectionHandler
implements ClassServerDelegate {
    private static Logger log = LoggerFactory.getLogger(AbstractClassServerDelegate.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected boolean stop = false;
    protected boolean closed = false;
    protected ResourceProvider resourceProvider = new ResourceProvider();
    protected String appUuid = null;

    protected AbstractClassServerDelegate(JPPFClientConnection owner) {
        super(owner);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void initSocketClient() throws Exception {
        this.socketClient = new SocketClient();
        this.socketClient.setHost(this.host);
        this.socketClient.setPort(this.port);
    }

    protected JPPFResourceWrapper readResource() throws Exception {
        JPPFBuffer buffer = this.socketClient.receiveBytes(0);
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        byte[] data = transform == null ? buffer.getBuffer() : JPPFDataTransformFactory.transform((JPPFDataTransform)transform, (boolean)false, (byte[])buffer.buffer, (int)0, (int)buffer.length);
        return (JPPFResourceWrapper)this.socketClient.getSerializer().deserialize(data);
    }

    protected void writeResource(JPPFResourceWrapper resource) throws Exception {
        byte[] data;
        JPPFBuffer buffer = this.socketClient.getSerializer().serialize((Object)resource);
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        byte[] byArray = data = transform == null ? buffer.getBuffer() : JPPFDataTransformFactory.transform((JPPFDataTransform)transform, (boolean)true, (byte[])buffer.buffer, (int)0, (int)buffer.length);
        if (debugEnabled) {
            log.debug("sending " + data.length + " bytes to the server");
        }
        this.socketClient.sendBytes(new JPPFBuffer(data, data.length));
        this.socketClient.flush();
    }
}

