/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jppf.client.AbstractJPPFClient;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFMulticastReceiverThread;
import org.jppf.client.loadbalancer.LoadBalancer;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFThreadFactory;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericClient
extends AbstractJPPFClient {
    private static Logger log = LoggerFactory.getLogger(AbstractGenericClient.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected ThreadPoolExecutor executor = null;
    protected TypedProperties config = null;
    protected JPPFMulticastReceiverThread receiverThread = null;
    protected LoadBalancer loadBalancer = null;
    private Map<String, ClassLoader> classLoaderMap = new Hashtable<String, ClassLoader>();

    public AbstractGenericClient(Object configuration) {
        this.initConfig(configuration);
        this.initPools();
    }

    public AbstractGenericClient(String uuid, Object configuration) {
        super(uuid);
        this.initConfig(configuration);
        this.initPools();
    }

    protected abstract void initConfig(Object var1);

    protected void initPools() {
        this.loadBalancer = new LoadBalancer();
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.MICROSECONDS, queue, (ThreadFactory)new JPPFThreadFactory("JPPF Client"));
        if (this.config.getBoolean("jppf.remote.execution.enabled", true)) {
            if (this.config.getBoolean("jppf.discovery.enabled", true)) {
                this.initPoolsFromAutoDiscovery();
            } else {
                this.initPoolsFromConfig();
            }
        }
    }

    private void initPoolsFromConfig() {
        try {
            String[] names;
            String driverNames = this.config.getString("jppf.drivers", "default-driver");
            if (driverNames == null || "".equals(driverNames.trim())) {
                driverNames = "default-driver";
            }
            if (debugEnabled) {
                log.debug("list of drivers: " + driverNames);
            }
            String[] stringArray = names = driverNames.split("\\s");
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                int n3 = this.config.getInt(String.valueOf(name) + ".jppf.pool.size", 1);
                if (n3 <= 0) {
                    n3 = 1;
                }
                int i = 1;
                while (i <= n3) {
                    JPPFConnectionInformation info = new JPPFConnectionInformation();
                    info.host = this.config.getString(String.valueOf(name) + ".jppf.server.host", "localhost");
                    info.classServerPorts = new int[]{this.config.getInt(String.valueOf(name) + ".class.server.port", 11111)};
                    info.applicationServerPorts = new int[]{this.config.getInt(String.valueOf(name) + ".app.server.port", 11112)};
                    info.managementPort = this.config.getInt(String.valueOf(name) + ".jppf.management.port", 11198);
                    AbstractJPPFClientConnection c = this.createConnection(this.uuid, n3 > 1 ? String.valueOf(name) + "-" + i : name, info);
                    c.setPriority(this.config.getInt(String.valueOf(name) + ".priority", 0));
                    this.newConnection(c);
                    ++i;
                }
                ++n2;
            }
            this.waitForPools(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initPoolsFromAutoDiscovery() {
        try {
            this.receiverThread = new JPPFMulticastReceiverThread(this);
            new Thread(this.receiverThread).start();
            this.waitForPools(false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract AbstractJPPFClientConnection createConnection(String var1, String var2, JPPFConnectionInformation var3);

    public void newConnection(JPPFClientConnection c) {
        log.info("Connection [" + c.getName() + "] created");
        c.addClientConnectionStatusListener(this);
        c.setStatus(JPPFClientConnectionStatus.NEW);
        int priority = c.getPriority();
        AbstractJPPFClient.ClientPool pool = (AbstractJPPFClient.ClientPool)this.pools.get(priority);
        if (pool == null) {
            pool = new AbstractJPPFClient.ClientPool();
            pool.setPriority(priority);
            this.pools.put(priority, pool);
        }
        pool.clientList.add(c);
        this.allConnections.add(c);
        int n = this.allConnections.size();
        if (this.executor.getCorePoolSize() < n) {
            this.executor.setMaximumPoolSize(n);
            this.executor.setCorePoolSize(n);
        }
        this.executor.submit(new ConnectionInitializer(c));
        super.newConnection(c);
    }

    private void waitForPools(boolean returnOnEmptyPool) {
        if (returnOnEmptyPool && this.pools.isEmpty()) {
            return;
        }
        long maxWait = JPPFConfiguration.getProperties().getLong("jppf.client.max.init.time", 5000L);
        if (maxWait <= 0L) {
            return;
        }
        long elapsed = 0L;
        while (elapsed < maxWait) {
            long start;
            block5: {
                start = System.currentTimeMillis();
                if (this.getClientConnection(true) != null) break;
                try {
                    Thread.sleep(50L);
                }
                catch (Exception ignored) {
                    if (!debugEnabled) break block5;
                    log.debug(ignored.getMessage(), (Throwable)ignored);
                }
            }
            elapsed += System.currentTimeMillis() - start;
        }
    }

    public void close() {
        super.close();
        if (this.receiverThread != null) {
            this.receiverThread.setStopped(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public TypedProperties getConfig() {
        return this.config;
    }

    public void addRequestClassLoader(String uuid, ClassLoader cl) {
        this.classLoaderMap.put(uuid, cl);
    }

    public void removeRequestClassLoader(String uuid) {
        this.classLoaderMap.remove(uuid);
    }

    public ClassLoader getRequestClassLoader(String uuid) {
        return this.classLoaderMap.get(uuid);
    }

    protected static class ConnectionInitializer
    implements Runnable {
        private JPPFClientConnection c = null;

        public ConnectionInitializer(JPPFClientConnection c) {
            this.c = c;
        }

        public void run() {
            if (debugEnabled) {
                log.debug("initializing driver connection '" + this.c + "'");
            }
            this.c.init();
        }
    }
}

