/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.jppf.JPPFError;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.event.ClientEvent;
import org.jppf.client.event.ClientListener;
import org.jppf.client.event.TaskResultListener;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.security.JPPFSecurityContext;
import org.jppf.server.protocol.JPPFJobSLA;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.JPPFUuid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJPPFClient
implements ClientConnectionStatusListener {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClient.class);
    private boolean debugEnabled = log.isDebugEnabled();
    protected JPPFSecurityContext credentials = null;
    protected int totalTaskCount = 0;
    protected TreeMap<Integer, ClientPool> pools = new TreeMap(new DescendingIntegerComparator());
    protected String uuid = null;
    protected List<JPPFClientConnection> allConnections = new ArrayList<JPPFClientConnection>();
    protected List<ClientListener> listeners = new ArrayList<ClientListener>();

    protected AbstractJPPFClient() {
        this(new JPPFUuid().toString());
    }

    protected AbstractJPPFClient(String uuid) {
        this.uuid = uuid;
        if (this.debugEnabled) {
            log.debug("Instantiating JPPF client with uuid=" + uuid);
        }
    }

    protected abstract void initPools();

    public List<JPPFClientConnection> getAllConnections() {
        return new ArrayList<JPPFClientConnection>(this.allConnections);
    }

    public List<String> getAllConnectionNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (JPPFClientConnection c : this.allConnections) {
            names.add(c.getName());
        }
        return names;
    }

    public JPPFClientConnection getClientConnection(String name) {
        for (JPPFClientConnection c : this.allConnections) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public JPPFClientConnection getClientConnection() {
        return this.getClientConnection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFClientConnection getClientConnection(boolean oneAttempt) {
        JPPFClientConnection client = null;
        TreeMap<Integer, ClientPool> treeMap = this.pools;
        synchronized (treeMap) {
            while (client == null && !this.pools.isEmpty()) {
                HashSet<Integer> toRemove = new HashSet<Integer>();
                Iterator<Integer> poolIterator = this.pools.keySet().iterator();
                block8: while (client == null && poolIterator.hasNext()) {
                    int priority = poolIterator.next();
                    ClientPool pool = this.pools.get(priority);
                    int size = pool.clientList.size();
                    int count = 0;
                    while (client == null && count < pool.size()) {
                        JPPFClientConnection c = pool.nextClient();
                        if (c == null) continue block8;
                        switch (c.getStatus()) {
                            case ACTIVE: {
                                client = c;
                                break;
                            }
                            case FAILED: {
                                pool.clientList.remove(c);
                                if (pool.getLastUsedIndex() >= --size) {
                                    pool.setLastUsedIndex(pool.getLastUsedIndex() - 1);
                                }
                                if (!pool.clientList.isEmpty()) break;
                                toRemove.add(priority);
                            }
                        }
                        ++count;
                    }
                }
                for (Integer n : toRemove) {
                    this.pools.remove(n);
                }
                if (this.pools.isEmpty()) {
                    log.warn("No more driver connection available for this client");
                }
                if (oneAttempt) break;
            }
        }
        if (this.debugEnabled && client != null) {
            log.debug("found client connection \"" + client + "\"");
        }
        return client;
    }

    public void initCredentials() throws Exception {
    }

    public List<JPPFTask> submit(List<JPPFTask> taskList, DataProvider dataProvider) throws Exception {
        return this.submit(taskList, dataProvider, null, 0);
    }

    public List<JPPFTask> submit(List<JPPFTask> taskList, DataProvider dataProvider, ExecutionPolicy policy) throws Exception {
        return this.submit(taskList, dataProvider, policy, 0);
    }

    public List<JPPFTask> submit(List<JPPFTask> taskList, DataProvider dataProvider, ExecutionPolicy policy, int priority) throws Exception {
        JPPFJobSLA sla = new JPPFJobSLA(policy, priority);
        JPPFJob job = new JPPFJob(dataProvider, sla, true, null);
        for (JPPFTask task : taskList) {
            job.addTask(task, new Object[0]);
        }
        return this.submit(job);
    }

    public void submitNonBlocking(List<JPPFTask> taskList, DataProvider dataProvider, TaskResultListener listener) throws Exception {
        this.submitNonBlocking(taskList, dataProvider, listener, null, 0);
    }

    public void submitNonBlocking(List<JPPFTask> taskList, DataProvider dataProvider, TaskResultListener listener, ExecutionPolicy policy) throws Exception {
        this.submitNonBlocking(taskList, dataProvider, listener, policy, 0);
    }

    public void submitNonBlocking(List<JPPFTask> taskList, DataProvider dataProvider, TaskResultListener listener, ExecutionPolicy policy, int priority) throws Exception {
        JPPFJobSLA sla = new JPPFJobSLA(policy, priority);
        JPPFJob job = new JPPFJob(dataProvider, sla, false, listener);
        for (JPPFTask task : taskList) {
            job.addTask(task, new Object[0]);
        }
        this.submit(job);
    }

    public abstract List<JPPFTask> submit(JPPFJob var1) throws Exception;

    @Override
    public void statusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnection c = (JPPFClientConnection)event.getClientConnectionStatusHandler();
        if (c.getStatus().equals((Object)JPPFClientConnectionStatus.FAILED)) {
            this.connectionFailed(c);
        }
    }

    protected void connectionFailed(JPPFClientConnection c) {
        log.info("Connection [" + c.getName() + "] failed");
        c.removeClientConnectionStatusListener(this);
        int priority = c.getPriority();
        ClientPool pool = this.pools.get(priority);
        if (pool != null) {
            pool.clientList.remove(c);
            if (pool.clientList.isEmpty()) {
                this.pools.remove(priority);
            }
            if (this.pools.isEmpty()) {
                throw new JPPFError("FATAL ERROR: No more driver connection available for this client");
            }
        }
        List<JPPFJob> toResubmit = c.close();
        int taskCount = 0;
        int execCount = toResubmit.size();
        for (JPPFJob exec : toResubmit) {
            if (exec.getTasks() == null) continue;
            taskCount += exec.getTasks().size();
        }
        if (taskCount > 0) {
            log.info("Connection [" + c.getName() + "] : resubmitting " + taskCount + "tasks for " + execCount + " executions");
        }
        try {
            for (JPPFJob job : toResubmit) {
                this.submit(job);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void close() {
        List<JPPFClientConnection> list = this.getAllConnections();
        for (JPPFClientConnection c : list) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void addClientListener(ClientListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeClientListener(ClientListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void newConnection(JPPFClientConnection c) {
        for (ClientListener listener : this.listeners) {
            listener.newConnection(new ClientEvent(c));
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public static class ClientPool {
        private int priority = 0;
        private int lastUsedIndex = 0;
        public List<JPPFClientConnection> clientList = new ArrayList<JPPFClientConnection>();

        public JPPFClientConnection nextClient() {
            if (this.clientList.isEmpty()) {
                return null;
            }
            ++this.lastUsedIndex;
            this.lastUsedIndex %= this.clientList.size();
            return this.clientList.get(this.getLastUsedIndex());
        }

        public int size() {
            return this.clientList.size();
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public int getLastUsedIndex() {
            return this.lastUsedIndex;
        }

        public void setLastUsedIndex(int lastUsedIndex) {
            this.lastUsedIndex = lastUsedIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DescendingIntegerComparator
    implements Comparator<Integer>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected DescendingIntegerComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return o2 - o1;
        }
    }
}

