/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jppf.JPPFException;
import org.jppf.classloader.NonDelegatingClassLoader;
import org.jppf.client.AbstractGenericClient;
import org.jppf.client.ClassServerDelegate;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFJob;
import org.jppf.client.TaskServerConnectionHandler;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.loadbalancer.LoadBalancer;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.io.IOHelper;
import org.jppf.security.JPPFCredentials;
import org.jppf.security.JPPFSecurityContext;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.Pair;
import org.jppf.utils.SerializationHelper;
import org.jppf.utils.TraversalList;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.VersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJPPFClientConnection
implements JPPFClientConnection {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClientConnection.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static String SERIALIZATION_HELPER_IMPL = "org.jppf.utils.SerializationHelperImpl";
    protected TaskServerConnectionHandler taskServerConnection = null;
    protected ClassServerDelegate delegate = null;
    protected String appUuid = null;
    protected String host = null;
    protected int port = -1;
    protected int classServerPort = -1;
    protected JPPFSecurityContext credentials = null;
    protected int totalTaskCount = 0;
    protected String name = null;
    protected int priority = 0;
    protected JPPFClientConnectionStatus status = JPPFClientConnectionStatus.CONNECTING;
    protected List<ClientConnectionStatusListener> listeners = new ArrayList<ClientConnectionStatusListener>();
    protected JPPFJob job = null;
    protected boolean isShutdown = false;
    private String connectionId = new JPPFUuid().toString();
    protected ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>());
    protected AbstractGenericClient client = null;

    protected void configure(String uuid, String name, String host, int driverPort, int classServerPort, int priority) {
        this.appUuid = uuid;
        this.host = NetworkUtils.getHostName((String)host);
        this.port = driverPort;
        this.priority = priority;
        this.classServerPort = classServerPort;
        this.name = name;
        this.taskServerConnection = new TaskServerConnectionHandler(this, this.host, this.port);
    }

    @Override
    public abstract void init();

    public void initCredentials() throws Exception {
        StringBuilder sb = new StringBuilder("Client:");
        sb.append(VersionUtils.getLocalIpAddress()).append(":");
        TypedProperties props = JPPFConfiguration.getProperties();
        sb.append(props.getInt("class.server.port", 11111)).append(":");
        sb.append(this.port).append(":");
        this.credentials = new JPPFSecurityContext(this.appUuid, sb.toString(), new JPPFCredentials());
    }

    public void sendTasks(JPPFJob job) throws Exception {
        try {
            JPPFTaskBundle bundle = new JPPFTaskBundle();
            this.sendTasks(bundle, job);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void sendTasks(JPPFTaskBundle header, JPPFJob job) throws Exception {
        ObjectSerializer ser = this.makeHelper().getSerializer();
        int count = job.getTasks().size();
        if (debugEnabled) {
            log.debug("[client: " + this.name + "] sending job '" + job.getId() + "' with " + count + " tasks");
        }
        TraversalList uuidPath = new TraversalList();
        uuidPath.add((Object)this.appUuid);
        header.setUuidPath(uuidPath);
        header.setTaskCount(count);
        header.setRequestUuid(job.getJobUuid());
        header.setParameter((Object)BundleParameter.JOB_ID, (Object)job.getId());
        header.setParameter((Object)BundleParameter.JOB_UUID, (Object)job.getJobUuid());
        header.setJobSLA(job.getJobSLA());
        header.setParameter((Object)BundleParameter.JOB_METADATA, (Object)job.getJobMetadata());
        SocketWrapper socketClient = this.taskServerConnection.getSocketClient();
        IOHelper.sendData((SocketWrapper)socketClient, (Object)header, (ObjectSerializer)ser);
        IOHelper.sendData((SocketWrapper)socketClient, (Object)job.getDataProvider(), (ObjectSerializer)ser);
        for (JPPFTask task : job.getTasks()) {
            IOHelper.sendData((SocketWrapper)socketClient, (Object)task, (ObjectSerializer)ser);
        }
        socketClient.flush();
    }

    public Pair<List<JPPFTask>, Integer> receiveResults() throws Exception {
        try {
            SocketWrapper socketClient = this.taskServerConnection.getSocketClient();
            ObjectSerializer ser = this.makeHelper().getSerializer();
            JPPFTaskBundle bundle = (JPPFTaskBundle)IOHelper.unwrappedData((SocketWrapper)socketClient, (ObjectSerializer)ser);
            int count = bundle.getTaskCount();
            if (debugEnabled) {
                log.debug("received bundle with " + count + " tasks for job '" + bundle.getId() + "'");
            }
            ArrayList<JPPFTask> taskList = new ArrayList<JPPFTask>();
            int i = 0;
            while (i < count) {
                taskList.add((JPPFTask)IOHelper.unwrappedData((SocketWrapper)socketClient, (ObjectSerializer)ser));
                ++i;
            }
            int startIndex = taskList.isEmpty() ? -1 : ((JPPFTask)taskList.get(0)).getPosition();
            Throwable t = (Throwable)bundle.getParameter((Object)BundleParameter.NODE_EXCEPTION_PARAM);
            if (t != null) {
                if (debugEnabled) {
                    log.debug("server returned exception parameter in the header for job '" + bundle.getId() + "' : " + t);
                }
                Exception e = t instanceof Exception ? (Exception)t : new JPPFException(t);
                for (JPPFTask task : taskList) {
                    task.setException(e);
                }
            }
            Pair p = new Pair(taskList, (Object)startIndex);
            return p;
        }
        catch (AsynchronousCloseException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Pair<List<JPPFTask>, Integer> receiveResults(ClassLoader cl) throws Exception {
        ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
        Pair<List<JPPFTask>, Integer> results = null;
        try {
            results = this.receiveResults();
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(prevCl);
            }
        }
        return results;
    }

    protected SerializationHelper makeHelper() throws Exception {
        return this.makeHelper(null);
    }

    protected SerializationHelper makeHelper(ClassLoader cl) throws Exception {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        NonDelegatingClassLoader ndCl = new NonDelegatingClassLoader(null, cl);
        String helperClassName = this.getSerializationHelperClassName();
        Class<?> clazz = null;
        if (cl != null) {
            try {
                clazz = ndCl.loadClassDirect(helperClassName);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (clazz == null) {
            cl = this.getClass().getClassLoader();
            clazz = cl.loadClass(helperClassName);
        }
        SerializationHelper helper = (SerializationHelper)clazz.newInstance();
        return helper;
    }

    protected String getSerializationHelperClassName() {
        return JPPFConfiguration.getProperties().getString("jppf.serialization.helper.class", SERIALIZATION_HELPER_IMPL);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public synchronized JPPFClientConnectionStatus getStatus() {
        return this.status;
    }

    @Override
    public synchronized void setStatus(JPPFClientConnectionStatus status) {
        JPPFClientConnectionStatus oldStatus = this.getStatus();
        this.status = status;
        if (!status.equals((Object)oldStatus)) {
            this.fireStatusChanged(oldStatus);
        }
    }

    @Override
    public synchronized void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireStatusChanged(JPPFClientConnectionStatus oldStatus) {
        ClientConnectionStatusListener[] array;
        ClientConnectionStatusEvent event = new ClientConnectionStatusEvent(this, oldStatus);
        ClientConnectionStatusListener[] clientConnectionStatusListenerArray = array = this.listeners.toArray(new ClientConnectionStatusListener[0]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ClientConnectionStatusListener listener = clientConnectionStatusListenerArray[n2];
            listener.statusChanged(event);
            ++n2;
        }
    }

    @Override
    public abstract List<JPPFJob> close();

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + " : " + (Object)((Object)this.status);
    }

    protected abstract SocketInitializer createSocketInitializer();

    public JPPFJob getCurrentJob() {
        return this.job;
    }

    public void setCurrentJob(JPPFJob currentExecution) {
        this.job = currentExecution;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public TaskServerConnectionHandler getTaskServerConnection() {
        return this.taskServerConnection;
    }

    public void delegateStatusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnectionStatus s1 = event.getClientConnectionStatusHandler().getStatus();
        JPPFClientConnectionStatus s2 = this.taskServerConnection.getStatus();
        this.processStatusChanged(s1, s2);
    }

    public void taskServerConnectionStatusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnectionStatus s1 = event.getClientConnectionStatusHandler().getStatus();
        JPPFClientConnectionStatus s2 = this.delegate.getStatus();
        this.processStatusChanged(s2, s1);
    }

    protected void processStatusChanged(JPPFClientConnectionStatus delegateStatus, JPPFClientConnectionStatus taskConnectionStatus) {
        if (JPPFClientConnectionStatus.FAILED.equals((Object)delegateStatus)) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
        } else if (JPPFClientConnectionStatus.ACTIVE.equals((Object)delegateStatus)) {
            if (JPPFClientConnectionStatus.ACTIVE.equals((Object)taskConnectionStatus) && !JPPFClientConnectionStatus.ACTIVE.equals((Object)this.getStatus())) {
                this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            } else if (!taskConnectionStatus.equals((Object)this.getStatus())) {
                this.setStatus(taskConnectionStatus);
            }
        } else if (JPPFClientConnectionStatus.ACTIVE.equals((Object)taskConnectionStatus)) {
            this.setStatus(delegateStatus);
        } else {
            int n = delegateStatus.compareTo(taskConnectionStatus);
            if (n < 0 && !delegateStatus.equals((Object)this.getStatus())) {
                this.setStatus(delegateStatus);
            } else if (!taskConnectionStatus.equals((Object)this.getStatus())) {
                this.setStatus(taskConnectionStatus);
            }
        }
    }

    public LoadBalancer getLoadBalancer() {
        return this.client.getLoadBalancer();
    }

    public AbstractGenericClient getClient() {
        return this.client;
    }
}

