/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.List;
import org.jppf.JPPFException;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.client.AbstractClassServerDelegate;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassServerDelegateImpl
extends AbstractClassServerDelegate {
    private static Logger log = LoggerFactory.getLogger(ClassServerDelegateImpl.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public ClassServerDelegateImpl(JPPFClientConnection owner, String uuid, String host, int port) throws Exception {
        super(owner);
        this.appUuid = uuid;
        this.host = host;
        this.port = port;
        this.setName(owner.getName());
    }

    public final void init() throws Exception {
        try {
            this.socketInitializer.setName("[" + this.getName() + " - delegate] ");
            this.setStatus(JPPFClientConnectionStatus.CONNECTING);
            if (this.socketClient == null) {
                this.initSocketClient();
            }
            System.out.println("[client: " + this.getName() + "] Attempting connection to the class server at " + this.host + ":" + this.port);
            this.socketInitializer.initializeSocket(this.socketClient);
            if (!this.socketInitializer.isSuccessfull() && !this.socketInitializer.isClosed()) {
                throw new JPPFException("[" + this.getName() + "] Could not reconnect to the class server");
            }
            if (!this.socketInitializer.isClosed()) {
                System.out.println("[client: " + this.getName() + "] Reconnected to the class server");
                this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            }
        }
        catch (Exception e) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
            throw e;
        }
    }

    public void run() {
        try {
            JPPFResourceWrapper resource = new JPPFResourceWrapper();
            resource.setState(JPPFResourceWrapper.State.PROVIDER_INITIATION);
            resource.addUuid(this.appUuid);
            this.writeResource(resource);
            resource = this.readResource();
            while (!this.stop) {
                try {
                    boolean found = true;
                    resource = this.readResource();
                    String name = resource.getName();
                    ClassLoader cl = this.getClassLoader(resource.getRequestUuid());
                    if (debugEnabled) {
                        log.debug("[" + this.getName() + "] resource requested: " + name + " using classloader=" + cl);
                    }
                    if (resource.getData("multiple") == null) {
                        byte[] b = null;
                        byte[] callable = resource.getCallable();
                        b = callable != null ? this.resourceProvider.computeCallable(callable) : (resource.isAsResource() ? this.resourceProvider.getResource(name, cl) : this.resourceProvider.getResourceAsBytes(name, cl));
                        if (b == null) {
                            found = false;
                        }
                        if (callable == null) {
                            resource.setDefinition(b);
                        } else {
                            resource.setCallable(b);
                        }
                        if (debugEnabled) {
                            if (found) {
                                log.debug("[" + this.getName() + "] sent resource: " + name + " (" + b.length + " bytes)");
                            } else {
                                log.debug("[" + this.getName() + "] resource not found: " + name);
                            }
                        }
                    } else {
                        List list = this.resourceProvider.getMultipleResourcesAsBytes(name, cl);
                        if (list != null) {
                            resource.setData("resource_list", (Object)list);
                        }
                    }
                    resource.setState(JPPFResourceWrapper.State.PROVIDER_RESPONSE);
                    this.writeResource(resource);
                }
                catch (Exception e) {
                    if (this.closed) continue;
                    log.warn("[" + this.getName() + "] caught " + e + ", will re-initialise ...", (Throwable)e);
                    this.init();
                }
            }
        }
        catch (Exception e) {
            log.error("[" + this.getName() + "] " + e.getMessage(), (Throwable)e);
            this.close();
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.stop = true;
            try {
                this.socketInitializer.close();
                this.socketClient.close();
            }
            catch (Exception e) {
                log.error("[" + this.getName() + "] " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected SocketInitializer createSocketInitializer() {
        return new SocketInitializerImpl();
    }

    private ClassLoader getClassLoader(String uuid) {
        return ((JPPFClientConnectionImpl)this.owner).getClient().getRequestClassLoader(uuid);
    }
}

