/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jppf.JPPFException;
import org.jppf.client.event.TaskResultListener;
import org.jppf.client.taskwrapper.JPPFAnnotatedTask;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.server.protocol.JPPFDistributedJob;
import org.jppf.server.protocol.JPPFJobMetadata;
import org.jppf.server.protocol.JPPFJobSLA;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.JPPFUuid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFJob
implements Serializable,
JPPFDistributedJob {
    private static final long serialVersionUID = 1L;
    private List<JPPFTask> tasks = null;
    private DataProvider dataProvider = null;
    private transient TaskResultListener resultsListener = null;
    private boolean blocking = true;
    private String id = null;
    private String jobUuid = null;
    private List<JPPFTask> results = null;
    private JPPFJobSLA jobSLA = new JPPFJobSLA();
    private JPPFJobMetadata jobMetadata = new JPPFJobMetadata();
    private int taskCount = 0;

    public JPPFJob() {
        this.id = this.jobUuid = new JPPFUuid(JPPFUuid.HEXADECIMAL, 32).toString();
    }

    public JPPFJob(String jobUuid) {
        this.jobUuid = jobUuid == null ? new JPPFUuid(JPPFUuid.HEXADECIMAL, 32).toString() : jobUuid;
        this.id = jobUuid;
    }

    public JPPFJob(DataProvider dataProvider) {
        this(dataProvider, null, true, null);
    }

    public JPPFJob(DataProvider dataProvider, JPPFJobSLA jobSLA) {
        this(dataProvider, jobSLA, true, null);
    }

    public JPPFJob(TaskResultListener resultsListener) {
        this(null, null, false, resultsListener);
    }

    public JPPFJob(DataProvider dataProvider, TaskResultListener resultsListener) {
        this(dataProvider, null, false, resultsListener);
    }

    public JPPFJob(DataProvider dataProvider, JPPFJobSLA jobSLA, TaskResultListener resultsListener) {
        this(dataProvider, jobSLA, false, resultsListener);
    }

    public JPPFJob(DataProvider dataProvider, JPPFJobSLA jobSLA, boolean blocking, TaskResultListener resultsListener) {
        this(dataProvider, jobSLA, null, blocking, resultsListener);
    }

    public JPPFJob(DataProvider dataProvider, JPPFJobSLA jobSLA, JPPFJobMetadata jobMetadata, boolean blocking, TaskResultListener resultsListener) {
        this();
        this.dataProvider = dataProvider;
        if (jobSLA != null) {
            this.jobSLA = jobSLA;
        }
        if (jobMetadata != null) {
            this.jobMetadata = jobMetadata;
        }
        this.resultsListener = resultsListener;
        this.blocking = blocking;
    }

    public String getJobUuid() {
        return this.jobUuid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<JPPFTask> getTasks() {
        return this.tasks;
    }

    public JPPFTask addTask(Object taskObject, Object ... args) throws JPPFException {
        Object jppfTask = null;
        if (taskObject == null) {
            throw new JPPFException("null tasks are not accepted");
        }
        jppfTask = taskObject instanceof JPPFTask ? (JPPFTask)taskObject : new JPPFAnnotatedTask(taskObject, args);
        if (this.tasks == null) {
            this.tasks = new ArrayList<JPPFTask>();
        }
        this.tasks.add((JPPFTask)jppfTask);
        jppfTask.setPosition(this.taskCount++);
        return jppfTask;
    }

    public JPPFTask addTask(String method, Object taskObject, Object ... args) throws JPPFException {
        if (taskObject == null) {
            throw new JPPFException("null tasks are not accepted");
        }
        if (this.tasks == null) {
            this.tasks = new ArrayList<JPPFTask>();
        }
        JPPFAnnotatedTask jppfTask = new JPPFAnnotatedTask(taskObject, method, args);
        this.tasks.add((JPPFTask)jppfTask);
        jppfTask.setPosition(this.taskCount++);
        return jppfTask;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public TaskResultListener getResultListener() {
        return this.resultsListener;
    }

    public void setResultListener(TaskResultListener resultsListener) {
        this.resultsListener = resultsListener;
        this.blocking = false;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public ExecutionPolicy getExecutionPolicy() {
        return this.jobSLA.getExecutionPolicy();
    }

    public void setExecutionPolicy(ExecutionPolicy executionPolicy) {
        this.jobSLA.setExecutionPolicy(executionPolicy);
    }

    public int getPriority() {
        return this.jobSLA.getPriority();
    }

    public void setPriority(int priority) {
        this.jobSLA.setPriority(priority);
    }

    public JPPFJobSLA getJobSLA() {
        return this.jobSLA;
    }

    public void setJobSLA(JPPFJobSLA jobSLA) {
        this.jobSLA = jobSLA;
    }

    public JPPFJobMetadata getJobMetadata() {
        return this.jobMetadata;
    }

    public void setJobMetadata(JPPFJobMetadata jobMetadata) {
        this.jobMetadata = jobMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jobUuid == null ? 0 : this.jobUuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JPPFJob)) {
            return false;
        }
        JPPFJob other = (JPPFJob)obj;
        if (this.jobUuid == null && other.jobUuid != null) {
            return false;
        }
        return this.jobUuid.equals(other.jobUuid);
    }
}

