/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.client.AbstractGenericClient;
import org.jppf.client.AbstractJPPFClientConnection;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.discovery.JPPFMulticastReceiver;
import org.jppf.utils.ThreadSynchronization;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JPPFMulticastReceiverThread
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(JPPFMulticastReceiverThread.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Map<String, Set<JPPFConnectionInformation>> infoMap = new HashMap<String, Set<JPPFConnectionInformation>>();
    private AtomicInteger count = new AtomicInteger(0);
    private AbstractGenericClient client = null;

    JPPFMulticastReceiverThread(AbstractGenericClient client) {
        this.client = client;
    }

    public void run() {
        TypedProperties config = this.client.getConfig();
        JPPFMulticastReceiver receiver = new JPPFMulticastReceiver(new IPFilter(config));
        try {
            try {
                while (!this.isStopped()) {
                    JPPFConnectionInformation info = receiver.receive();
                    InetAddress ip = InetAddress.getByName(info.host);
                    if (info == null || this.hasConnectionInformation(info)) continue;
                    if (debugEnabled) {
                        log.debug("Found connection information: " + info);
                    }
                    this.addConnectionInformation(info);
                    int n = config.getInt("jppf.pool.size", 1);
                    if (n < 1) {
                        n = 1;
                    }
                    int currentCount = this.count.incrementAndGet();
                    int i = 1;
                    while (i <= n) {
                        String name = "driver-" + currentCount + (n == 1 ? "" : "-" + i);
                        AbstractJPPFClientConnection c = this.client.createConnection(this.client.getUuid(), name, info);
                        this.client.newConnection(c);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (receiver != null) {
                    receiver.setStopped(true);
                }
            }
        }
        finally {
            if (receiver != null) {
                receiver.setStopped(true);
            }
        }
    }

    private boolean hasConnectionInformation(JPPFConnectionInformation info) {
        Set<JPPFConnectionInformation> set = this.infoMap.get(info.uuid);
        if (set == null) {
            return false;
        }
        return set.contains(info);
    }

    private void addConnectionInformation(JPPFConnectionInformation info) {
        Set<JPPFConnectionInformation> set = this.infoMap.get(info.uuid);
        if (set == null) {
            set = new HashSet<JPPFConnectionInformation>();
            this.infoMap.put(info.uuid, set);
        }
        set.add(info);
    }
}

