/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jppf.client.event.TaskResultEvent;
import org.jppf.client.event.TaskResultListener;
import org.jppf.server.protocol.JPPFTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFResultCollector
implements TaskResultListener {
    private static Logger log = LoggerFactory.getLogger(JPPFResultCollector.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected int pendingCount = 0;
    protected Map<Integer, JPPFTask> resultMap = new TreeMap<Integer, JPPFTask>();
    protected List<JPPFTask> results = null;

    public JPPFResultCollector(int count) {
        this.pendingCount = count;
    }

    @Override
    public synchronized void resultsReceived(TaskResultEvent event) {
        List<JPPFTask> tasks = event.getTaskList();
        if (debugEnabled) {
            log.debug("Received results for " + tasks.size() + " tasks");
        }
        for (JPPFTask task : tasks) {
            this.resultMap.put(task.getPosition(), task);
        }
        this.pendingCount -= tasks.size();
        this.notify();
    }

    public synchronized List<JPPFTask> waitForResults() {
        return this.waitForResults(Long.MAX_VALUE);
    }

    public synchronized List<JPPFTask> waitForResults(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("wait time cannot be negative");
        }
        if (debugEnabled) {
            log.debug("timeout = " + millis);
        }
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (elapsed < millis && this.pendingCount > 0) {
            try {
                this.wait(millis - elapsed);
                if (elapsed >= millis) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            elapsed = System.currentTimeMillis() - start;
        }
        if (this.pendingCount <= 0) {
            this.results = new ArrayList<JPPFTask>();
            for (Map.Entry<Integer, JPPFTask> entry : this.resultMap.entrySet()) {
                this.results.add(entry.getValue());
            }
        }
        if (debugEnabled) {
            log.debug("elapsed = " + elapsed);
        }
        return this.results;
    }

    public List<JPPFTask> getResults() {
        return this.results;
    }
}

