/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import org.jppf.JPPFException;
import org.jppf.client.AbstractClientConnectionHandler;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.comm.socket.SocketClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServerConnectionHandler
extends AbstractClientConnectionHandler {
    private static Logger log = LoggerFactory.getLogger(TaskServerConnectionHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public TaskServerConnectionHandler(JPPFClientConnection owner, String host, int port) {
        super(owner);
        this.host = host;
        this.port = port;
    }

    protected SocketInitializer createSocketInitializer() {
        return new SocketInitializerImpl();
    }

    public void init() throws Exception {
        try {
            this.setStatus(JPPFClientConnectionStatus.CONNECTING);
            if (this.socketClient == null) {
                this.initSocketClient();
            }
            String msg = "[client: " + this.name + "] Attempting connection to the JPPF task server at " + this.host + ":" + this.port;
            System.out.println(msg);
            if (debugEnabled) {
                log.debug(msg);
            }
            this.socketInitializer.initializeSocket(this.socketClient);
            if (!this.socketInitializer.isSuccessfull()) {
                throw new JPPFException("[" + this.name + "] Could not reconnect to the JPPF task server");
            }
            msg = "[client: " + this.name + "] Reconnected to the JPPF task server";
            System.out.println(msg);
            if (debugEnabled) {
                log.debug(msg);
            }
            this.setStatus(JPPFClientConnectionStatus.ACTIVE);
        }
        catch (Exception e) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
            throw e;
        }
    }

    public void initSocketClient() throws Exception {
        this.socketClient = new SocketClient();
        this.socketClient.setHost(this.host);
        this.socketClient.setPort(this.port);
    }

    public void close() {
        try {
            if (this.socketInitializer != null) {
                this.socketInitializer.close();
            }
            if (this.socketClient != null) {
                this.socketClient.close();
            }
        }
        catch (Exception e) {
            log.error("[" + this.name + "] " + e.getMessage(), (Throwable)e);
        }
    }
}

