/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFJob;
import org.jppf.client.concurrent.BatchHandler;
import org.jppf.client.concurrent.FutureResultCollector;
import org.jppf.client.concurrent.FutureResultCollectorEvent;
import org.jppf.client.concurrent.FutureResultCollectorListener;
import org.jppf.client.concurrent.JPPFTaskFuture;
import org.jppf.client.concurrent.RunnableWrapper;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.DateTimeUtils;
import org.jppf.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFExecutorService
implements ExecutorService,
FutureResultCollectorListener {
    private static Logger log = LoggerFactory.getLogger(JPPFExecutorService.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private JPPFClient client = null;
    private Map<String, JPPFJob> jobMap = new Hashtable<String, JPPFJob>();
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private AtomicBoolean terminated = new AtomicBoolean(false);
    private BatchHandler batchHandler = null;

    public JPPFExecutorService(JPPFClient client) {
        this.client = client;
        this.batchHandler = new BatchHandler(this);
        new Thread((Runnable)this.batchHandler, "BatchHandler").start();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(tasks, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        long millis;
        if (this.shuttingDown.get()) {
            throw new RejectedExecutionException("Shutdown has already been requested");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        long start = System.currentTimeMillis();
        long l = millis = TimeUnit.MILLISECONDS.equals((Object)unit) ? timeout : DateTimeUtils.toMillis((long)timeout, (TimeUnit)unit);
        if (debugEnabled) {
            log.debug("timeout in millis: " + millis);
        }
        Pair<FutureResultCollector, Integer> pair = this.batchHandler.addTasks(tasks);
        FutureResultCollector collector = (FutureResultCollector)pair.first();
        int position = (Integer)pair.second();
        ArrayList<Future<T>> futureList = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            if (task == null) {
                throw new NullPointerException("a task cannot be null");
            }
            JPPFTaskFuture future = new JPPFTaskFuture(collector, position);
            futureList.add(future);
            long elapsed = System.currentTimeMillis() - start;
            future.getResult(millis - elapsed);
            ++position;
        }
        return futureList;
    }

    private <T> void handleFutureList(List<Future<T>> futureList) {
        for (Future<T> f : futureList) {
            if (f.isDone()) continue;
            JPPFTaskFuture future = (JPPFTaskFuture)f;
            future.setDone();
            future.setCancelled();
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.invokeAny(tasks, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        List<Future<T>> futureList = this.invokeAll(tasks, timeout, unit);
        this.handleFutureList(futureList);
        for (Future<T> f : futureList) {
            if (!f.isDone() || f.isCancelled()) continue;
            return f.get();
        }
        return null;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this.shuttingDown.get()) {
            throw new RejectedExecutionException("Shutdown has already been requested");
        }
        return this.batchHandler.addTask(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task instanceof JPPFTask) {
            if (this.shuttingDown.get()) {
                throw new RejectedExecutionException("Shutdown has already been requested");
            }
            return this.batchHandler.addTask((JPPFTask)task);
        }
        return this.submit(new RunnableWrapper<Object>(task, null));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(new RunnableWrapper<T>(task, result));
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long millis = DateTimeUtils.toMillis((long)timeout, (TimeUnit)unit);
        this.waitForTerminated(millis);
        return this.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.shuttingDown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTerminated() {
        this.terminated.set(true);
        JPPFExecutorService jPPFExecutorService = this;
        synchronized (jPPFExecutorService) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.shuttingDown.set(true);
        Map<String, JPPFJob> map = this.jobMap;
        synchronized (map) {
            if (debugEnabled) {
                log.debug("normal shutdown requested, " + this.jobMap.size() + " jobs pending");
            }
            this.terminated.compareAndSet(false, this.jobMap.isEmpty());
        }
        this.batchHandler.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.shuttingDown.set(true);
        Map<String, JPPFJob> map = this.jobMap;
        synchronized (map) {
            if (debugEnabled) {
                log.debug("immediate shutdown requested, " + this.jobMap.size() + " jobs pending");
            }
            this.jobMap.clear();
        }
        this.setTerminated();
        this.batchHandler.close();
        this.waitForTerminated(Long.MAX_VALUE);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitJob(JPPFJob job) throws Exception {
        if (debugEnabled) {
            log.debug("submitting job '" + job.getId() + "' with " + job.getTasks().size() + " tasks");
        }
        this.client.submit(job);
        Map<String, JPPFJob> map = this.jobMap;
        synchronized (map) {
            this.jobMap.put(job.getJobUuid(), job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTerminated(long timeout) {
        long elapsed = 0L;
        long start = System.currentTimeMillis();
        while (!this.isTerminated() && elapsed < timeout) {
            JPPFExecutorService jPPFExecutorService = this;
            synchronized (jPPFExecutorService) {
                try {
                    this.wait(timeout - elapsed);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                elapsed = System.currentTimeMillis() - start;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resultsComplete(FutureResultCollectorEvent event) {
        String jobUuid = event.getCollector().getJobUuid();
        Map<String, JPPFJob> map = this.jobMap;
        synchronized (map) {
            this.jobMap.remove(jobUuid);
            if (this.isShutdown() && this.jobMap.isEmpty()) {
                this.setTerminated();
            }
        }
    }

    public int getBatchSize() {
        return this.batchHandler.getBatchSize();
    }

    public void setBatchSize(int batchSize) {
        this.batchHandler.setBatchSize(batchSize);
    }

    public long getBatchTimeout() {
        return this.batchHandler.getBatchTimeout();
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchHandler.setBatchTimeout(batchTimeout);
    }
}

