/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jppf.client.concurrent.AbstractJPPFFuture;
import org.jppf.client.concurrent.FutureResultCollector;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPPFTaskFuture<V>
extends AbstractJPPFFuture<V> {
    private static Logger log = LoggerFactory.getLogger(JPPFTaskFuture.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private FutureResultCollector collector = null;
    private int position = -1;

    public JPPFTaskFuture(FutureResultCollector collector, int position) {
        this.collector = collector;
        this.position = position;
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        V v;
        block2: {
            v = null;
            try {
                v = this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                if (!debugEnabled) break block2;
                log.debug("wait timed out, but it shouldn't have", (Throwable)e);
            }
        }
        return v;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long millis = TimeUnit.MILLISECONDS.equals((Object)unit) ? timeout : DateTimeUtils.toMillis((long)timeout, (TimeUnit)unit);
        this.getResult(millis);
        if (this.timedout.get()) {
            throw new TimeoutException("wait timed out");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return (V)this.result;
    }

    void getResult(long timeout) {
        if (!this.isDone()) {
            JPPFTask task = null;
            task = timeout > 0L ? this.collector.waitForTask(this.position, timeout) : this.collector.getTask(this.position);
            this.setDone();
            if (task == null) {
                this.setCancelled();
                this.timedout.set(timeout > 0L);
            } else {
                this.result = task.getResult();
                this.exception = task.getException();
            }
        }
    }

    void setDone() {
        this.done.set(true);
    }

    void setCancelled() {
        this.cancelled.set(true);
    }

    public JPPFTask getTask() {
        return this.collector.getTask(this.position);
    }
}

