/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceCache;
import org.jppf.utils.IteratorEnumeration;
import org.jppf.utils.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFClassLoader
extends URLClassLoader {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClassLoader.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected static final ReentrantLock LOCK = new ReentrantLock();
    protected static final AtomicBoolean INITIALIZING = new AtomicBoolean(false);
    protected boolean dynamic = false;
    protected List<String> uuidPath = new ArrayList<String>();
    protected String requestUuid = null;
    protected ResourceCache cache = new ResourceCache();
    protected ObjectSerializer serializer = null;

    public AbstractJPPFClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        if (parent instanceof AbstractJPPFClassLoader) {
            this.dynamic = true;
        }
    }

    public AbstractJPPFClassLoader(ClassLoader parent, List<String> uuidPath) {
        this(parent);
        this.uuidPath = uuidPath;
    }

    protected abstract void init();

    public abstract void reset();

    public synchronized Class<?> loadJPPFClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (debugEnabled) {
            log.debug("looking up resource [" + name + "]");
        }
        if ((c = this.findLoadedClass(name)) != null) {
            ClassLoader cl = c.getClassLoader();
            if (debugEnabled) {
                log.debug("classloader = " + cl);
            }
        }
        if (c == null) {
            if (debugEnabled) {
                log.debug("resource [" + name + "] not already loaded");
            }
            c = this.findClass(name);
        }
        if (debugEnabled) {
            log.debug("definition for resource [" + name + "] : " + c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            String pkgName;
            Package pkg;
            LOCK.lock();
            int i = name.lastIndexOf(46);
            if (i >= 0 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            if (debugEnabled) {
                log.debug("looking up definition for resource [" + name + "]");
            }
            byte[] b = null;
            String resName = name.replace('.', '/') + ".class";
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", resName);
            JPPFResourceWrapper resource = this.loadResourceData(map, false);
            if (resource == null) {
                throw new ClassNotFoundException("could not find reosurce " + name);
            }
            b = resource.getDefinition();
            if (b == null || b.length == 0) {
                if (debugEnabled) {
                    log.debug("definition for resource [" + name + "] not found");
                }
                throw new ClassNotFoundException("Could not load class '" + name + "'");
            }
            if (debugEnabled) {
                log.debug("found definition for resource [" + name + ", definitionLength=" + b.length + "]");
            }
            Class<?> clazz = this.defineClass(name, b, 0, b.length);
            return clazz;
        }
        finally {
            LOCK.unlock();
        }
    }

    private JPPFResourceWrapper loadResourceData(Map<String, Object> map, boolean asResource) throws ClassNotFoundException {
        JPPFResourceWrapper resource;
        block10: {
            resource = null;
            try {
                if (debugEnabled) {
                    log.debug("loading remote definition for resource [" + map.get("name") + "]");
                }
                resource = this.loadResourceData0(map, asResource);
            }
            catch (IOException e) {
                if (debugEnabled) {
                    log.debug("connection with class server ended, re-initializing");
                }
                this.init();
                try {
                    resource = this.loadResourceData0(map, asResource);
                }
                catch (ClassNotFoundException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    if (debugEnabled) {
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                if (!debugEnabled) break block10;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return resource;
    }

    private JPPFResourceWrapper loadResourceData0(Map<String, Object> map, boolean asResource) throws Exception {
        if (debugEnabled) {
            log.debug("loading remote definition for resource [" + map.get("name") + "], requestUuid = " + this.requestUuid);
        }
        JPPFResourceWrapper resource = this.loadRemoteData(map, false);
        if (debugEnabled) {
            log.debug("remote definition for resource [" + map.get("name") + "] " + (resource.getDefinition() == null ? "not " : "") + "found");
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] computeRemoteData(byte[] callable) throws Exception {
        try {
            LOCK.lock();
            if (debugEnabled) {
                log.debug("requesting remote computation, requestUuid = " + this.requestUuid);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("callable", callable);
            byte[] b = this.loadRemoteData(map, false).getCallable();
            if (debugEnabled) {
                log.debug("remote definition for collable resource " + (b == null ? "not " : "") + "found");
            }
            byte[] byArray = b;
            return byArray;
        }
        finally {
            LOCK.unlock();
        }
    }

    protected abstract JPPFResourceWrapper loadRemoteData(Map<String, Object> var1, boolean var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String name) {
        URL url = null;
        if (debugEnabled) {
            log.debug("resource [" + name + "] not found locally, attempting remote lookup");
        }
        try {
            Enumeration<URL> urlEnum = this.findResources(name);
            if (urlEnum != null && urlEnum.hasMoreElements()) {
                url = urlEnum.nextElement();
            }
        }
        catch (IOException iOException) {}
        if (debugEnabled) {
            log.debug("resource [" + name + "] " + (url == null ? "not " : "") + "found remotely");
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
        if (is == null) {
            if (debugEnabled) {
                log.debug("resource [" + name + "] not found locally, attempting remote lookup");
            }
            try {
                boolean found;
                LOCK.lock();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", name);
                JPPFResourceWrapper resource = this.loadResourceData(map, true);
                byte[] b = resource.getDefinition();
                boolean bl = found = b != null && b.length > 0;
                if (debugEnabled) {
                    log.debug("resource [" + name + "] " + (found ? "" : "not ") + "found remotely");
                }
                if (!found) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                is = new ByteArrayInputStream(b);
            }
            catch (ClassNotFoundException e) {
                if (debugEnabled) {
                    log.debug("resource [" + name + "] not found remotely");
                }
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                LOCK.unlock();
            }
        }
        return is;
    }

    static boolean isInitializing() {
        return INITIALIZING.get();
    }

    static void setInitializing(boolean initFlag) {
        INITIALIZING.set(initFlag);
    }

    public void setRequestUuid(String requestUuid) {
        this.requestUuid = requestUuid;
    }

    @Override
    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> urlList = null;
        if (debugEnabled) {
            log.debug("resource [" + name + "] not found locally, attempting remote lookup");
        }
        try {
            LOCK.lock();
            List<String> locationsList = this.cache.getResourcesLocations(name);
            if (locationsList == null) {
                boolean found;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", name);
                map.put("multiple", "true");
                JPPFResourceWrapper resource = this.loadResourceData(map, true);
                List dataList = (List)resource.getData("resource_list");
                boolean bl = found = dataList != null && !dataList.isEmpty();
                if (debugEnabled) {
                    log.debug("resource [" + name + "] " + (found ? "" : "not ") + "found remotely");
                }
                if (found) {
                    this.cache.registerResources(name, dataList);
                    urlList = new ArrayList();
                    locationsList = this.cache.getResourcesLocations(name);
                }
            }
            if (locationsList != null) {
                for (String path : locationsList) {
                    File file = new File(path);
                    if (urlList == null) {
                        urlList = new ArrayList<URL>();
                    }
                    urlList.add(file.toURI().toURL());
                }
                if (debugEnabled) {
                    log.debug("found the following URLs for resource [" + name + "] : " + urlList);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug("resource [" + name + "] not found remotely");
            }
        }
        finally {
            LOCK.unlock();
        }
        return urlList == null ? null : new IteratorEnumeration(urlList.iterator());
    }

    protected ObjectSerializer getSerializer() throws Exception {
        if (this.serializer == null) {
            this.serializer = (ObjectSerializer)this.getParent().loadClass("org.jppf.comm.socket.BootstrapObjectSerializer").newInstance();
        }
        return this.serializer;
    }
}

