/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.comm.socket.BootstrapSocketClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.data.transform.JPPFDataTransform;
import org.jppf.data.transform.JPPFDataTransformFactory;
import org.jppf.node.NodeRunner;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.TraversalList;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFClassLoader
extends AbstractJPPFClassLoader {
    private static Logger log = LoggerFactory.getLogger(JPPFClassLoader.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static SocketWrapper socketClient = null;
    private static SocketInitializer socketInitializer = new SocketInitializerImpl();

    public JPPFClassLoader(ClassLoader parent) {
        super(parent);
        this.init();
    }

    public JPPFClassLoader(ClassLoader parent, List<String> uuidPath) {
        super(parent, uuidPath);
    }

    private void initSocketClient() {
        if (debugEnabled) {
            log.debug("initializing socket connection");
        }
        TypedProperties props = JPPFConfiguration.getProperties();
        String host = props.getString("jppf.server.host", "localhost");
        int port = props.getInt("class.server.port", 11111);
        socketClient = new BootstrapSocketClient();
        socketClient.setHost(host);
        socketClient.setPort(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        if (!JPPFClassLoader.isInitializing()) {
            try {
                LOCK.lock();
                if (debugEnabled) {
                    log.debug("initializing connection");
                }
                JPPFClassLoader.setInitializing(true);
                if (socketClient == null) {
                    this.initSocketClient();
                }
                System.out.println("Attempting connection to the class server at " + socketClient.getHost() + ":" + socketClient.getPort());
                socketInitializer.initializeSocket(socketClient);
                if (!socketInitializer.isSuccessfull()) {
                    socketClient = null;
                    throw new JPPFNodeReconnectionNotification("Could not reconnect to the server");
                }
                try {
                    if (debugEnabled) {
                        log.debug("sending node initiation message");
                    }
                    JPPFResourceWrapper resource = new JPPFResourceWrapper();
                    resource.setState(JPPFResourceWrapper.State.NODE_INITIATION);
                    resource.setData("node.uuid", NodeRunner.getUuid());
                    ObjectSerializer serializer = socketClient.getSerializer();
                    JPPFBuffer buf = serializer.serialize(resource);
                    byte[] data = buf.getBuffer();
                    data = JPPFDataTransformFactory.transform(true, data);
                    socketClient.sendBytes(new JPPFBuffer(data, data.length));
                    socketClient.flush();
                    if (debugEnabled) {
                        log.debug("node initiation message sent, getting response");
                    }
                    socketClient.receiveBytes(0);
                    if (debugEnabled) {
                        log.debug("received node initiation response");
                    }
                }
                catch (IOException e) {
                    throw new JPPFNodeReconnectionNotification("Could not reconnect to the driver", e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                System.out.println("Reconnected to the class server");
            }
            finally {
                LOCK.unlock();
                JPPFClassLoader.setInitializing(false);
            }
        }
        if (debugEnabled) {
            log.debug("waiting for end of connection initialization");
        }
        try {
            LOCK.lock();
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        LOCK.lock();
        try {
            socketClient = null;
            this.init();
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block6: {
            LOCK.lock();
            try {
                block7: {
                    if (socketInitializer != null) {
                        socketInitializer.close();
                    }
                    if (socketClient == null) break block6;
                    try {
                        socketClient.close();
                    }
                    catch (Exception e) {
                        if (!debugEnabled) break block7;
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                }
                socketClient = null;
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    @Override
    protected JPPFResourceWrapper loadRemoteData(Map<String, Object> map, boolean asResource) throws Exception {
        JPPFResourceWrapper resource = new JPPFResourceWrapper();
        resource.setState(JPPFResourceWrapper.State.NODE_REQUEST);
        resource.setDynamic(this.dynamic);
        TraversalList<String> list = new TraversalList<String>(this.uuidPath);
        resource.setUuidPath(list);
        if (list.size() > 0) {
            list.setPosition(this.uuidPath.size() - 1);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            resource.setData(entry.getKey(), entry.getValue());
        }
        resource.setAsResource(asResource);
        resource.setRequestUuid(this.requestUuid);
        JPPFDataTransform transform = JPPFDataTransformFactory.getInstance();
        ObjectSerializer serializer = this.getSerializer();
        JPPFBuffer buf = serializer.serialize(resource);
        byte[] data = buf.getBuffer();
        if (transform != null) {
            data = JPPFDataTransformFactory.transform(transform, true, data);
        }
        socketClient.writeInt(data.length);
        socketClient.write(data, 0, data.length);
        socketClient.flush();
        buf = socketClient.receiveBytes(0);
        data = buf.getBuffer();
        if (transform != null) {
            data = JPPFDataTransformFactory.transform(transform, false, data);
        }
        resource = (JPPFResourceWrapper)serializer.deserialize(data);
        return resource;
    }
}

