/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.LocalClassLoaderChannel;
import org.jppf.node.NodeRunner;
import org.jppf.utils.FileUtils;
import org.jppf.utils.TraversalList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFLocalClassLoader
extends AbstractJPPFClassLoader {
    private static Logger log = LoggerFactory.getLogger(JPPFLocalClassLoader.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static LocalClassLoaderChannel channel = null;

    public JPPFLocalClassLoader(LocalClassLoaderChannel ioHandler, ClassLoader parent) {
        super(parent);
        channel = ioHandler;
        this.init();
    }

    public JPPFLocalClassLoader(ClassLoader parent, List<String> uuidPath) {
        super(parent, uuidPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        block16: {
            LOCK.lock();
            try {
                if (JPPFLocalClassLoader.isInitializing()) break block16;
                JPPFLocalClassLoader.setInitializing(true);
                try {
                    if (debugEnabled) {
                        log.debug("sending node initiation message");
                    }
                    JPPFResourceWrapper resource = new JPPFResourceWrapper();
                    resource.setState(JPPFResourceWrapper.State.NODE_INITIATION);
                    resource.setData("node.uuid", NodeRunner.getUuid());
                    LocalClassLoaderChannel localClassLoaderChannel = channel;
                    synchronized (localClassLoaderChannel) {
                        channel.setServerResource(resource);
                        channel.setReadyOps(1);
                    }
                    while (channel.getServerResource() != null) {
                        channel.getServerLock().goToSleep();
                    }
                    if (debugEnabled) {
                        log.debug("node initiation message sent");
                    }
                    localClassLoaderChannel = channel;
                    synchronized (localClassLoaderChannel) {
                        channel.setNodeResource(null);
                        channel.setReadyOps(4);
                    }
                    while (channel.getNodeResource() == null) {
                        channel.getNodeLock().goToSleep();
                    }
                    channel.setNodeResource(null);
                    if (debugEnabled) {
                        log.debug("received node initiation response");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                System.out.println(this.getClass().getSimpleName() + ".init(): Reconnected to the class server");
            }
            finally {
                LOCK.unlock();
                JPPFLocalClassLoader.setInitializing(false);
            }
        }
    }

    @Override
    public void reset() {
        this.init();
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized Class<?> loadJPPFClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (debugEnabled) {
            log.debug("looking up resource [" + name + "]");
        }
        if ((c = this.findLoadedClass(name)) == null) {
            if (debugEnabled) {
                log.debug("resource [" + name + "] not already loaded");
            }
            ClassLoader cl = this;
            while (cl instanceof AbstractJPPFClassLoader) {
                cl = cl.getParent();
            }
            if (cl != null) {
                String pkgName;
                Package pkg;
                int i = name.lastIndexOf(46);
                if (i >= 0 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
                String resName = name.replace(".", "/") + ".class";
                InputStream is = cl.getResourceAsStream(resName);
                try {
                    byte[] definition = FileUtils.getInputStreamAsByte(is);
                    c = this.defineClass(name, definition, 0, definition.length);
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        if (debugEnabled) {
            log.debug("definition for resource [" + name + "] : " + c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JPPFResourceWrapper loadRemoteData(Map<String, Object> map, boolean asResource) throws Exception {
        JPPFResourceWrapper resource = new JPPFResourceWrapper();
        resource.setState(JPPFResourceWrapper.State.NODE_REQUEST);
        resource.setDynamic(this.dynamic);
        TraversalList<String> list = new TraversalList<String>(this.uuidPath);
        resource.setUuidPath(list);
        if (list.size() > 0) {
            list.setPosition(this.uuidPath.size() - 1);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            resource.setData(entry.getKey(), entry.getValue());
        }
        resource.setAsResource(asResource);
        resource.setRequestUuid(this.requestUuid);
        LocalClassLoaderChannel localClassLoaderChannel = channel;
        synchronized (localClassLoaderChannel) {
            channel.setServerResource(resource);
            channel.setReadyOps(1);
        }
        while (channel.getServerResource() != null) {
            channel.getServerLock().goToSleep();
        }
        channel.setReadyOps(4);
        while (channel.getNodeResource() == null) {
            channel.getNodeLock().goToSleep();
        }
        resource = (JPPFResourceWrapper)channel.getNodeResource();
        channel.setNodeResource(null);
        return resource;
    }
}

