/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jppf.classloader.SaveFileAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceCache {
    private static Logger log = LoggerFactory.getLogger(ResourceCache.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Map<String, List<String>> cache = new Hashtable<String, List<String>>();

    ResourceCache() {
    }

    public List<String> getResourcesLocations(String name) {
        return this.cache.get(name);
    }

    public String getResourceLocation(String name) {
        List<String> locations = this.cache.get(name);
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        return locations.get(0);
    }

    public void setResourcesLocations(String name, List<String> locations) {
        this.cache.put(name, locations);
    }

    public void setResourceLocation(String name, String location) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(location);
        this.cache.put(name, list);
    }

    public void registerResources(String name, List<byte[]> definitions) throws Exception {
        ArrayList<String> locations = new ArrayList<String>();
        for (byte[] def : definitions) {
            locations.add(this.saveToTempFile(def));
        }
        this.setResourcesLocations(name, locations);
    }

    private String saveToTempFile(byte[] definition) throws Exception {
        SaveFileAction action = new SaveFileAction(definition);
        File file = AccessController.doPrivileged(action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return file.getCanonicalPath();
    }
}

