/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.classloader;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivilegedAction;
import org.jppf.JPPFException;

class SaveFileAction
implements PrivilegedAction<File> {
    private final byte[] definition;
    private Exception exception = null;

    public SaveFileAction(byte[] definition) {
        this.definition = definition;
    }

    @Override
    public File run() {
        File tmp = null;
        try {
            try {
                tmp = File.createTempFile("jppftemp_", ".tmp");
            }
            catch (IOException e) {
                File tmpDir = new File(System.getProperty("user.dir") + File.separator + "temp" + File.separator);
                boolean created = true;
                if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                    created = tmpDir.mkdirs();
                }
                if (created) {
                    tmp = File.createTempFile("jppftemp_", ".tmp", tmpDir);
                }
                throw new JPPFException("Could not create temp dir " + tmpDir.getCanonicalPath());
            }
            tmp.deleteOnExit();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmp));
            bos.write(this.definition);
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            this.exception = e;
        }
        return tmp;
    }

    public Exception getException() {
        return this.exception;
    }
}

