/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.discovery;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.jppf.net.AbstractIPAddressPattern;
import org.jppf.net.IPv4AddressPattern;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFilter {
    private static Logger log = LoggerFactory.getLogger(IPFilter.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private List<AbstractIPAddressPattern> includePatterns = new ArrayList<AbstractIPAddressPattern>();
    private List<AbstractIPAddressPattern> excludePatterns = new ArrayList<AbstractIPAddressPattern>();
    private TypedProperties config = null;

    public IPFilter(TypedProperties config) {
        this.config = config == null ? new TypedProperties() : config;
        this.configure();
    }

    public void configure() {
        this.configureIPAddressPatterns(this.config.getString("jppf.discovery.include.ipv4"), this.includePatterns);
        this.configureIPAddressPatterns(this.config.getString("jppf.discovery.include.ipv6"), this.includePatterns);
        this.configureIPAddressPatterns(this.config.getString("jppf.discovery.exclude.ipv4"), this.excludePatterns);
        this.configureIPAddressPatterns(this.config.getString("jppf.discovery.exclude.ipv6"), this.excludePatterns);
    }

    private void configureIPAddressPatterns(String source, List<AbstractIPAddressPattern> addToList) {
        addToList.clear();
        if (source == null) {
            return;
        }
        if ("".equals(source = source.trim())) {
            return;
        }
        String[] p = source.split(",|;");
        if (p == null || p.length == 0) {
            return;
        }
        for (String s : p) {
            try {
                addToList.add(new IPv4AddressPattern(s));
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
    }

    public boolean isAddressAccepted(InetAddress ip) {
        int[] ipComps = StringUtils.toIntArray(ip);
        boolean included = this.matches(ipComps, this.includePatterns, true);
        boolean excluded = this.matches(ipComps, this.excludePatterns, false);
        return included && !excluded;
    }

    private boolean matches(int[] ipComps, List<AbstractIPAddressPattern> patterns, boolean defIfEmpty) {
        if (patterns == null || patterns.isEmpty()) {
            return defIfEmpty;
        }
        for (AbstractIPAddressPattern p : patterns) {
            if (!p.matches(ipComps)) continue;
            return true;
        }
        return false;
    }
}

