/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.discovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jppf.utils.StringUtils;

public class JPPFConnectionInformation
implements Serializable,
Comparable<JPPFConnectionInformation>,
Cloneable {
    private static final long serialVersionUID = 1L;
    public String host = null;
    public int[] classServerPorts = null;
    public int[] nodeServerPorts = null;
    public int[] applicationServerPorts = null;
    public int managementPort = -1;
    public int recoveryPort = -1;
    public transient String managementHost = null;
    public String uuid = null;
    public int subnetMaskLength = 0;

    @Override
    public int compareTo(JPPFConnectionInformation ci) {
        if (ci == null || ci.uuid == null) {
            return 1;
        }
        if (this.uuid == null) {
            return -1;
        }
        return this.uuid.compareTo(ci.uuid);
    }

    public int hashCode() {
        return this.managementPort + (this.host == null ? 0 : this.host.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPPFConnectionInformation other = (JPPFConnectionInformation)obj;
        if (this.host == null) {
            return other.host == null && other.managementPort == this.managementPort;
        }
        return this.host.equals(other.host) && other.managementPort == this.managementPort;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("uuid=").append(this.uuid);
        sb.append(", host=").append(this.host);
        sb.append(", class server=").append(StringUtils.buildString(this.classServerPorts));
        sb.append(", node server=").append(StringUtils.buildString(this.nodeServerPorts));
        sb.append(", app server=").append(StringUtils.buildString(this.applicationServerPorts));
        sb.append(", management=").append(this.managementPort);
        sb.append(", recoveryPort=").append(this.recoveryPort);
        sb.append("]");
        return sb.toString();
    }

    public static JPPFConnectionInformation fromBytes(byte[] bytes) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        JPPFConnectionInformation info = (JPPFConnectionInformation)ois.readObject();
        ois.close();
        return info;
    }

    public static byte[] toBytes(JPPFConnectionInformation info) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        oos.close();
        return baos.toByteArray();
    }
}

